/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.generator;

import io.avaje.validation.generator.APContext;
import io.avaje.validation.generator.AvajeValidPrism;
import io.avaje.validation.generator.GenericTypeMap;
import io.avaje.validation.generator.JakartaValidPrism;
import io.avaje.validation.generator.JavaxValidPrism;
import io.avaje.validation.generator.NonNullPrism;
import io.avaje.validation.generator.NullMarkedPrism;
import io.avaje.validation.generator.NullUnmarkedPrism;
import io.avaje.validation.generator.ProcessingContext;
import io.avaje.validation.generator.ProcessorUtils;
import io.avaje.validation.generator.UType;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class Util {
    private static final String NULLABLE = "Nullable";
    private static final Set<String> BASIC_TYPES = Set.of("java.lang.String", "java.math.BigDecimal");

    private Util() {
    }

    static boolean isValid(Element e) {
        return AvajeValidPrism.isPresent(e) || JavaxValidPrism.isPresent(e) || JakartaValidPrism.isPresent(e);
    }

    static boolean isNullable(Element p) {
        UType uType;
        if (ProcessorUtils.hasAnnotationWithName(p, NULLABLE)) {
            return true;
        }
        if (p instanceof ExecutableElement) {
            ExecutableElement ex = (ExecutableElement)p;
            uType = UType.parse(ex.getReturnType());
        } else {
            uType = UType.parse(p.asType());
        }
        UType type = uType;
        for (AnnotationMirror mirror : type.annotations()) {
            if (!NULLABLE.equalsIgnoreCase(Util.shortName(mirror.getAnnotationType().toString()))) continue;
            return true;
        }
        return false;
    }

    static boolean validImportType(String type, String packageName) {
        return type.indexOf(46) > -1 && !type.startsWith("java.lang.") && Util.importDifferentPackage(type, packageName) || Util.importJavaLangSubpackage(type);
    }

    private static boolean importDifferentPackage(String type, String packageName) {
        return type.replace(packageName + ".", "").indexOf(46) > 0;
    }

    private static boolean importJavaLangSubpackage(String type) {
        return type.startsWith("java.lang.") && Util.importDifferentPackage(type, "java.lang");
    }

    static String shortName(String fullType) {
        int p = fullType.lastIndexOf(46);
        if (p == -1) {
            return fullType;
        }
        return fullType.substring(p + 1);
    }

    static String initCap(String input) {
        if (input.length() < 2) {
            return input.toUpperCase();
        }
        return Character.toUpperCase(input.charAt(0)) + input.substring(1);
    }

    static String initLower(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        boolean toLower = true;
        for (char ch : name.toCharArray()) {
            if (Character.isUpperCase(ch)) {
                if (toLower) {
                    sb.append(Character.toLowerCase(ch));
                    continue;
                }
                sb.append(ch);
                continue;
            }
            sb.append(ch);
            toLower = false;
        }
        return sb.toString();
    }

    static String baseTypeOfAdapter(String adapterFullName) {
        TypeElement element = APContext.typeElement(adapterFullName);
        if (element == null) {
            throw new NullPointerException("Element not found for [" + adapterFullName + "]");
        }
        return Util.baseTypeOfAdapter(element);
    }

    static String baseTypeOfAdapter(TypeElement element) {
        return Optional.of(element.getSuperclass()).filter(t -> t.toString().contains("io.avaje.validation.adapter.AbstractConstraintAdapter") || t.toString().contains("io.avaje.validation.adapter.PrimitiveAdapter")).or(Util.validationAdapter(element)).map(UType::parse).map(UType::param0).map(UType::fullWithoutAnnotations).orElseGet(() -> {
            APContext.logError(element, "Custom Constraint adapters must extend AbstractConstraintAdapter or implement ValidationAdapter", new Object[0]);
            return "Invalid";
        });
    }

    static boolean isPrimitiveAdapter(TypeElement element) {
        return Optional.of(element.getSuperclass()).filter(t -> t.toString().contains("io.avaje.validation.adapter.PrimitiveAdapter")).or(Util.primitiveAdapter(element)).isPresent();
    }

    private static Supplier<Optional<? extends TypeMirror>> validationAdapter(TypeElement element) {
        return () -> element.getInterfaces().stream().filter(t -> t.toString().contains("io.avaje.validation.adapter.ValidationAdapter") || t.toString().contains("io.avaje.validation.adapter.ValidationAdapter.Primitive")).findFirst();
    }

    private static Supplier<Optional<? extends TypeMirror>> primitiveAdapter(TypeElement element) {
        return () -> element.getInterfaces().stream().filter(t -> t.toString().contains("io.avaje.validation.adapter.ValidationAdapter.Primitive")).findFirst();
    }

    static boolean isBasicType(String topType) {
        return BASIC_TYPES.contains(topType) || topType.startsWith("java.time.") || GenericTypeMap.typeOfRaw(topType) != null;
    }

    static boolean isPublic(Element element) {
        Set<Modifier> mods = element.getModifiers();
        if (mods.contains((Object)Modifier.PUBLIC)) {
            return true;
        }
        if (mods.contains((Object)Modifier.PRIVATE) || mods.contains((Object)Modifier.PROTECTED)) {
            return false;
        }
        return !ProcessingContext.isImported(element);
    }

    static String valhalla() {
        try {
            if (Modifier.valueOf("VALUE") != null && APContext.previewEnabled()) {
                return "value ";
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return "";
    }

    static boolean isNonNullable(Element e) {
        UType uType;
        if (e instanceof ExecutableElement) {
            ExecutableElement executableElement = (ExecutableElement)e;
            uType = UType.parse(executableElement.getReturnType());
        } else {
            uType = UType.parse(e.asType());
        }
        for (AnnotationMirror mirror : uType.annotations()) {
            if (mirror.getAnnotationType().toString().endsWith(NULLABLE)) {
                return false;
            }
            if (!NonNullPrism.isInstance(mirror)) continue;
            return true;
        }
        return Util.checkNullMarked(e);
    }

    private static boolean checkNullMarked(Element e) {
        if (e == null || NullUnmarkedPrism.isPresent(e)) {
            return false;
        }
        if (NullMarkedPrism.isPresent(e)) {
            return true;
        }
        return Util.checkNullMarked(e.getEnclosingElement());
    }
}

