/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.generator;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class ValidMethodPrism {
    private final String _locale;
    private final Boolean _throwOnParamFailure;
    public static final String PRISM_TYPE = "io.avaje.validation.ValidMethod";
    final Values values;
    final boolean isValid;
    final AnnotationMirror mirror;
    private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    static boolean isInstance(AnnotationMirror mirror) {
        return ValidMethodPrism.getInstance(mirror) != null;
    }

    static boolean isPresent(Element element) {
        return ValidMethodPrism.getInstanceOn(element) != null;
    }

    static ValidMethodPrism getInstanceOn(Element element) {
        AnnotationMirror mirror = ValidMethodPrism.getMirror(element);
        if (mirror == null) {
            return null;
        }
        return ValidMethodPrism.getInstance(mirror);
    }

    static Optional<ValidMethodPrism> getOptionalOn(Element element) {
        AnnotationMirror mirror = ValidMethodPrism.getMirror(element);
        if (mirror == null) {
            return Optional.empty();
        }
        return ValidMethodPrism.getOptional(mirror);
    }

    static ValidMethodPrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new ValidMethodPrism(mirror);
    }

    static Optional<ValidMethodPrism> getOptional(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return Optional.empty();
        }
        return Optional.of(new ValidMethodPrism(mirror));
    }

    private ValidMethodPrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._locale = this.getValue("locale", String.class);
        this._throwOnParamFailure = this.getValue("throwOnParamFailure", Boolean.class);
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public String locale() {
        return this._locale;
    }

    public Boolean throwOnParamFailure() {
        return this._throwOnParamFailure;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = ValidMethodPrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!PRISM_TYPE.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    static final class Values {
        private final Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        AnnotationValue locale() {
            return this.values.get("locale");
        }

        AnnotationValue throwOnParamFailure() {
            return this.values.get("throwOnParamFailure");
        }
    }
}

