/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.adapter;

import io.avaje.validation.adapter.ArrayValidationAdapter;
import io.avaje.validation.adapter.ContainerAdapter;
import io.avaje.validation.adapter.IterableValidationAdapter;
import io.avaje.validation.adapter.MapValidationAdapter;
import io.avaje.validation.adapter.OptionalValidationAdapter;
import io.avaje.validation.adapter.ValidationRequest;
import java.util.Objects;
import java.util.Set;

@FunctionalInterface
public interface ValidationAdapter<T> {
    public boolean validate(T var1, ValidationRequest var2, String var3);

    default public boolean validate(T value, ValidationRequest req) {
        return this.validate(value, req, null);
    }

    default public Primitive primitive() {
        throw new UnsupportedOperationException();
    }

    default public ContainerAdapter<T> list() {
        return new IterableValidationAdapter(this);
    }

    default public ContainerAdapter<T> mapKeys() {
        return new MapValidationAdapter(this, true);
    }

    default public ContainerAdapter<T> mapValues() {
        return new MapValidationAdapter(this, false);
    }

    default public ContainerAdapter<T> array() {
        return new ArrayValidationAdapter(this);
    }

    default public ContainerAdapter<T> optional() {
        return new OptionalValidationAdapter(this);
    }

    default public ValidationAdapter<T> andThen(ValidationAdapter<? super T> after) {
        Objects.requireNonNull(after, "after cannot be null");
        return (value, req, propertyName) -> {
            if (this.validate(value, req, propertyName)) {
                return after.validate(value, req, propertyName);
            }
            return true;
        };
    }

    default public boolean checkGroups(Set<Class<?>> adapterGroups, ValidationRequest request) {
        for (Class<?> group : request.groups()) {
            if (!adapterGroups.contains(group)) continue;
            return true;
        }
        return false;
    }

    public static interface Primitive {
        public boolean validate(boolean var1, ValidationRequest var2, String var3);

        public boolean validate(byte var1, ValidationRequest var2, String var3);

        public boolean validate(char var1, ValidationRequest var2, String var3);

        public boolean validate(double var1, ValidationRequest var3, String var4);

        public boolean validate(float var1, ValidationRequest var2, String var3);

        public boolean validate(int var1, ValidationRequest var2, String var3);

        public boolean validate(long var1, ValidationRequest var3, String var4);

        public boolean validate(short var1, ValidationRequest var2, String var3);
    }
}

