/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.core;

import io.avaje.lang.Nullable;
import io.avaje.validation.adapter.ValidationAdapter;
import io.avaje.validation.adapter.ValidationContext;
import io.avaje.validation.core.DValidator;
import io.avaje.validation.core.adapters.BasicAdapters;
import io.avaje.validation.core.adapters.FuturePastAdapterFactory;
import io.avaje.validation.core.adapters.NumberAdapters;
import io.avaje.validation.groups.Default;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

final class CoreAdapterBuilder {
    public static final ValidationAdapter NOOP = (type, req, propertyName) -> true;
    private static final Set<Class<?>> DEFAULT_GROUP = Set.of(Default.class);
    private final DValidator context;
    private final List<ValidationContext.AdapterFactory> factories = new ArrayList<ValidationContext.AdapterFactory>();
    private final List<ValidationContext.AnnotationFactory> annotationFactories = new ArrayList<ValidationContext.AnnotationFactory>();
    private final Map<Object, ValidationAdapter<?>> adapterCache = new ConcurrentHashMap();

    CoreAdapterBuilder(DValidator context, List<ValidationContext.AdapterFactory> userFactories, List<ValidationContext.AnnotationFactory> userAnnotationFactories, Supplier<Clock> clockSupplier, Duration temporalTolerance) {
        this.context = context;
        this.factories.addAll(userFactories);
        this.annotationFactories.addAll(userAnnotationFactories);
        this.annotationFactories.add(BasicAdapters.FACTORY);
        this.annotationFactories.add(NumberAdapters.FACTORY);
        this.annotationFactories.add(new FuturePastAdapterFactory(clockSupplier, temporalTolerance));
    }

    <T> ValidationAdapter<T> get(Object cacheKey) {
        return this.adapterCache.get(cacheKey);
    }

    <T> ValidationAdapter<T> build(Type type) {
        return this.build(type, type);
    }

    <T> ValidationAdapter<T> annotationAdapter(Class<? extends Annotation> cls, Map<String, Object> attributes, Set<Class<?>> groups) {
        return this.buildAnnotation(cls, attributes, groups);
    }

    <T> ValidationAdapter<T> build(Type type, Object cacheKey) {
        for (ValidationContext.AdapterFactory factory : this.factories) {
            ValidationAdapter<?> result = factory.create(type, this.context);
            if (result == null) continue;
            return result;
        }
        throw new IllegalArgumentException("No ValidationAdapter for " + String.valueOf(type) + ". Perhaps needs @Valid or @Valid.Import?");
    }

    <T> ValidationAdapter<T> buildAnnotation(Class<? extends Annotation> cls, Map<String, Object> attributes, @Nullable Set<Class<?>> groups) {
        Set<Class<?>> paramGroups;
        Set<Class<?>> set = paramGroups = groups != null ? groups : attributes.getOrDefault("groups", DEFAULT_GROUP);
        if (paramGroups.isEmpty()) {
            paramGroups = DEFAULT_GROUP;
        }
        Request request = new Request(this.context, cls, paramGroups, attributes);
        for (ValidationContext.AnnotationFactory factory : this.annotationFactories) {
            ValidationAdapter<?> result = factory.create(request);
            if (result == null) continue;
            return result;
        }
        return NOOP;
    }

    record Request(ValidationContext ctx, Class<? extends Annotation> annotationType, Set<Class<?>> groups, Map<String, Object> attributes) implements ValidationContext.AdapterCreateRequest
    {
        @Override
        public String targetType() {
            return (String)this.attribute("_type");
        }

        @Override
        public Object attribute(String key) {
            return this.attributes.get(key);
        }

        @Override
        public Request withValue(long value) {
            HashMap<String, Object> newAttributes = new HashMap<String, Object>(this.attributes);
            newAttributes.put("value", value);
            return new Request(this.ctx, this.annotationType, this.groups, newAttributes);
        }

        @Override
        public ValidationContext.Message message() {
            return this.ctx.message(this.attributes);
        }

        @Override
        public ValidationContext.Message message(String messageKey, Object ... extraKeyValues) {
            HashMap<String, Object> newAttributes = new HashMap<String, Object>(this.attributes);
            newAttributes.put("message", messageKey);
            if (extraKeyValues != null) {
                for (int i = 0; i < extraKeyValues.length; i += 2) {
                    newAttributes.put(String.valueOf(extraKeyValues[i]), extraKeyValues[i + 1]);
                }
            }
            return this.ctx.message(newAttributes);
        }
    }
}

