/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.core;

import io.avaje.lang.Nullable;
import io.avaje.validation.ConstraintViolation;
import io.avaje.validation.ConstraintViolationException;
import io.avaje.validation.adapter.ValidationContext;
import io.avaje.validation.adapter.ValidationRequest;
import io.avaje.validation.core.DValidator;
import io.avaje.validation.groups.Default;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

final class DRequest
implements ValidationRequest {
    private static final List<Class<?>> DEFAULT_GROUP = List.of(Default.class);
    private final ArrayDeque<String> pathStack = new ArrayDeque();
    private final Set<ConstraintViolation> violations = new LinkedHashSet<ConstraintViolation>();
    private final DValidator validator;
    private final boolean failfast;
    private final List<Class<?>> groups;
    @Nullable
    private final Locale locale;

    DRequest(DValidator validator, boolean failfast, @Nullable Locale locale, List<Class<?>> groups) {
        this.validator = validator;
        this.failfast = failfast;
        this.locale = locale;
        this.groups = !groups.isEmpty() ? groups : DEFAULT_GROUP;
    }

    private String currentPath() {
        if (this.pathStack.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(70);
        Iterator<String> descendingIterator = this.pathStack.descendingIterator();
        while (descendingIterator.hasNext()) {
            String next = descendingIterator.next();
            if (next.charAt(0) == '[') {
                sb.append(next).append(']');
                continue;
            }
            if (!sb.isEmpty()) {
                sb.append('.');
            }
            sb.append(next);
        }
        return sb.append('.').toString();
    }

    @Override
    public void addViolation(ValidationContext.Message msg, String propertyName) {
        String message = this.validator.interpolate(msg, this.locale);
        String field = this.field(propertyName);
        this.violations.add(new ConstraintViolation(this.currentPath() + field, field, message));
        if (this.failfast) {
            this.throwWithViolations();
        }
    }

    private String field(String propertyName) {
        return propertyName == null ? "" : propertyName;
    }

    @Override
    public void pushPath(String path) {
        this.pathStack.push(path);
    }

    @Override
    public void popPath() {
        this.pathStack.pop();
    }

    @Override
    public void throwWithViolations() {
        if (!this.violations.isEmpty()) {
            throw new ConstraintViolationException(this.message(), this.violations, this.groups);
        }
    }

    private String message() {
        StringBuilder msg = new StringBuilder(100);
        msg.append(this.violations.size()).append(" constraint violation(s) occurred.");
        this.violations.stream().limit(10L).forEach(cv -> msg.append("\n ").append(cv.path()).append(": ").append(cv.message()));
        int others = this.violations.size() - 10;
        if (others > 0) {
            msg.append("\n and ").append(others).append(" other error(s)");
        }
        return msg.toString();
    }

    @Override
    public Set<ConstraintViolation> violations() {
        return this.violations;
    }

    @Override
    public List<Class<?>> groups() {
        return this.groups;
    }

    public String toString() {
        return this.violations.toString();
    }

    @Override
    public boolean hasViolations() {
        return !this.violations.isEmpty();
    }
}

