/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.core;

import io.avaje.validation.core.ResourceBundleManager;
import java.util.Locale;

final class TemplateLookup {
    private final ResourceBundleManager bundleManager;

    TemplateLookup(ResourceBundleManager defaultBundle) {
        this.bundleManager = defaultBundle;
    }

    String lookup(String template, Locale resolvedLocale) {
        if (!this.isBundleKey(template)) {
            return template;
        }
        String key = template.substring(1, template.length() - 1);
        String msg = this.bundleManager.message(key, resolvedLocale);
        if (msg != null) {
            return this.lookup(msg, resolvedLocale);
        }
        return template;
    }

    private boolean isBundleKey(String template) {
        int pos = template.indexOf(123);
        if (pos != 0) {
            return false;
        }
        return template.charAt(template.length() - 1) == '}' && template.indexOf(123, 1) == -1;
    }
}

