/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.core.adapters;

import io.avaje.validation.adapter.AbstractConstraintAdapter;
import io.avaje.validation.adapter.PrimitiveAdapter;
import io.avaje.validation.adapter.RegexFlag;
import io.avaje.validation.adapter.ValidationAdapter;
import io.avaje.validation.adapter.ValidationContext;
import io.avaje.validation.adapter.ValidationRequest;
import io.avaje.validation.core.adapters.EmailAdapter;
import io.avaje.validation.core.adapters.UriAdapter;
import io.avaje.validation.core.adapters.UuidAdapter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public final class BasicAdapters {
    private static final String LENGTH_MAX = "{avaje.Length.max.message}";
    public static final ValidationContext.AnnotationFactory FACTORY = request -> switch (request.annotationType().getSimpleName()) {
        case "Email" -> new EmailAdapter(request);
        case "UUID" -> new UuidAdapter(request);
        case "URI" -> new UriAdapter(request);
        case "Null" -> new NullableAdapter(request, true);
        case "NotNull", "NonNull" -> new NullableAdapter(request, false);
        case "AssertTrue" -> new AssertBooleanAdapter(request, true);
        case "AssertFalse" -> new AssertBooleanAdapter(request, false);
        case "NotBlank" -> new NotBlankAdapter(request);
        case "NotEmpty" -> new NotEmptyAdapter(request);
        case "Pattern" -> new PatternAdapter(request);
        case "Size", "Length" -> new SizeAdapter(request);
        default -> null;
    };

    private BasicAdapters() {
    }

    private static int arrayLength(Object array) {
        if (array instanceof int[]) {
            int[] intArr = (int[])array;
            return intArr.length;
        }
        if (array instanceof boolean[]) {
            boolean[] boolArr = (boolean[])array;
            return boolArr.length;
        }
        if (array instanceof byte[]) {
            byte[] byteArr = (byte[])array;
            return byteArr.length;
        }
        if (array instanceof char[]) {
            char[] charArr = (char[])array;
            return charArr.length;
        }
        if (array instanceof short[]) {
            short[] shortArr = (short[])array;
            return shortArr.length;
        }
        if (array instanceof float[]) {
            float[] floatArr = (float[])array;
            return floatArr.length;
        }
        if (array instanceof double[]) {
            double[] doubleArr = (double[])array;
            return doubleArr.length;
        }
        if (array instanceof long[]) {
            long[] longArr = (long[])array;
            return longArr.length;
        }
        return ((Object[])array).length;
    }

    private static final class NullableAdapter
    extends AbstractConstraintAdapter<Object> {
        private final boolean shouldBeNull;

        NullableAdapter(ValidationContext.AdapterCreateRequest request, boolean shouldBeNull) {
            super(request);
            this.shouldBeNull = shouldBeNull;
        }

        @Override
        public boolean isValid(Object value) {
            return value == null == this.shouldBeNull;
        }
    }

    private static final class AssertBooleanAdapter
    extends PrimitiveAdapter<Boolean> {
        private final boolean assertBool;

        AssertBooleanAdapter(ValidationContext.AdapterCreateRequest request, boolean assertBool) {
            super(request);
            this.assertBool = assertBool;
        }

        @Override
        public boolean isValid(Boolean value) {
            return value == null || this.assertBool == value;
        }

        @Override
        public boolean isValid(boolean value) {
            return this.assertBool == value;
        }
    }

    private static final class NotBlankAdapter
    implements ValidationAdapter<CharSequence> {
        private final ValidationContext.Message message;
        private final ValidationContext.Message maxLengthMessage;
        private final Set<Class<?>> groups;
        private final int maxLength;

        NotBlankAdapter(ValidationContext.AdapterCreateRequest request) {
            this.groups = request.groups();
            this.message = request.message();
            this.maxLength = NotBlankAdapter.maxLength(request);
            this.maxLengthMessage = this.maxLength > 0 && NotBlankAdapter.standardMessage(request) ? request.message(BasicAdapters.LENGTH_MAX, "min", 1) : null;
        }

        private static int maxLength(ValidationContext.AdapterCreateRequest request) {
            Integer max = (Integer)request.attribute("max");
            return Objects.requireNonNullElse(max, 0);
        }

        private static boolean standardMessage(ValidationContext.AdapterCreateRequest request) {
            return "{avaje.NotBlank.message}".equals(request.attribute("message"));
        }

        @Override
        public boolean validate(CharSequence value, ValidationRequest req, String propertyName) {
            if (!this.checkGroups(this.groups, req)) {
                return true;
            }
            if (value == null || NotBlankAdapter.isBlank(value)) {
                req.addViolation(this.message, propertyName);
                return false;
            }
            if (this.maxLength > 0 && value.length() > this.maxLength) {
                req.addViolation(this.maxLengthMessage != null ? this.maxLengthMessage : this.message, propertyName);
                return false;
            }
            return true;
        }

        static boolean isBlank(CharSequence cs) {
            int strLen = cs.length();
            if (strLen == 0) {
                return true;
            }
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(cs.charAt(i))) continue;
                return false;
            }
            return true;
        }
    }

    private static final class NotEmptyAdapter
    extends AbstractConstraintAdapter<Object> {
        NotEmptyAdapter(ValidationContext.AdapterCreateRequest request) {
            super(request);
        }

        @Override
        public boolean isValid(Object value) {
            if (value == null) {
                return false;
            }
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                return !col.isEmpty();
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                return !map.isEmpty();
            }
            if (value instanceof CharSequence) {
                CharSequence sequence = (CharSequence)value;
                return sequence.length() != 0;
            }
            if (value.getClass().isArray()) {
                return BasicAdapters.arrayLength(value) != 0;
            }
            return true;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static class PatternAdapter
    extends AbstractConstraintAdapter<CharSequence> {
        protected final Predicate<String> pattern;

        PatternAdapter(ValidationContext.AdapterCreateRequest request) {
            this(request, (String)request.attribute("regexp"));
        }

        PatternAdapter(ValidationContext.AdapterCreateRequest request, String regex) {
            super(request);
            int flags = 0;
            List flags1 = (List)request.attribute("flags");
            if (flags1 != null) {
                for (RegexFlag flag : flags1) {
                    flags |= flag.getValue();
                }
            }
            this.pattern = Pattern.compile(regex, flags).asMatchPredicate().negate();
        }

        @Override
        public boolean isValid(CharSequence value) {
            return value == null || !this.pattern.test(value.toString());
        }
    }

    private static final class SizeAdapter
    implements ValidationAdapter<Object> {
        private static final String LENGTH = "{avaje.Length.message}";
        private static final String SIZE = "{avaje.Size.message}";
        private static final String SIZE_MAX = "{avaje.Size.max.message}";
        private final ValidationContext.Message message;
        private final Set<Class<?>> groups;
        private final int min;
        private final int max;

        SizeAdapter(ValidationContext.AdapterCreateRequest request) {
            this.groups = request.groups();
            this.min = (Integer)request.attribute("min");
            this.max = (Integer)request.attribute("max");
            Object msgKey = request.attribute("message");
            this.message = this.min == 0 && LENGTH.equals(msgKey) ? request.message(BasicAdapters.LENGTH_MAX, new Object[0]) : (this.min == 0 && SIZE.equals(msgKey) ? request.message(SizeAdapter.useLength(request) ? BasicAdapters.LENGTH_MAX : SIZE_MAX, new Object[0]) : (SIZE.equals(msgKey) && SizeAdapter.useLength(request) ? request.message(LENGTH, new Object[0]) : request.message()));
        }

        private static boolean useLength(ValidationContext.AdapterCreateRequest request) {
            String targetType = request.targetType();
            return "String".equals(targetType) || "CharSequence".equals(targetType);
        }

        @Override
        public boolean validate(Object value, ValidationRequest req, String propertyName) {
            int len;
            if (value == null || !this.checkGroups(this.groups, req)) {
                return true;
            }
            if (value instanceof CharSequence) {
                CharSequence sequence = (CharSequence)value;
                int len2 = sequence.length();
                if (len2 > this.max || len2 < this.min) {
                    req.addViolation(this.message, propertyName);
                    return false;
                }
            } else if (value instanceof Collection) {
                Collection col = (Collection)value;
                int len3 = col.size();
                if (len3 > this.max || len3 < this.min) {
                    req.addViolation(this.message, propertyName);
                    return len3 > 0;
                }
            } else if (value instanceof Map) {
                Map map = (Map)value;
                int len4 = map.size();
                if (len4 > this.max || len4 < this.min) {
                    req.addViolation(this.message, propertyName);
                    return len4 > 0;
                }
            } else if (value.getClass().isArray() && ((len = BasicAdapters.arrayLength(value)) > this.max || len < this.min)) {
                req.addViolation(this.message, propertyName);
                return len > 0;
            }
            return true;
        }
    }
}

