/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.core.adapters;

import io.avaje.validation.core.adapters.InfinityNumberComparatorHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.OptionalInt;

final class NumberComparatorHelper {
    private NumberComparatorHelper() {
    }

    static int compareDecimal(String targetType, Object number, BigDecimal value, OptionalInt treatNanAs) {
        if (targetType == null) {
            return NumberComparatorHelper.compareDecimal(number, value, treatNanAs);
        }
        return switch (targetType) {
            case "String", "CharSequence" -> new BigDecimal(number.toString()).compareTo(value);
            case "Double" -> NumberComparatorHelper.compareDouble((Double)number, value, treatNanAs);
            case "Float" -> NumberComparatorHelper.compareFloat((Float)number, value, treatNanAs);
            case "BigDecimal" -> ((BigDecimal)number).compareTo(value);
            case "BigInteger" -> new BigDecimal((BigInteger)number).compareTo(value);
            case "Byte", "Integer", "Long", "Short" -> BigDecimal.valueOf(((Number)number).longValue()).compareTo(value);
            default -> NumberComparatorHelper.compareDecimal(number, value, treatNanAs);
        };
    }

    private static int compareDecimal(Object number, BigDecimal value, OptionalInt treatNanAs) {
        if (number instanceof Number) {
            Number n = (Number)number;
            return NumberComparatorHelper.compareDouble((Double)n.doubleValue(), value, treatNanAs);
        }
        return new BigDecimal(number.toString()).compareTo(value);
    }

    static int compareDouble(Double number, long value, OptionalInt treatNanAs) {
        OptionalInt infinity = InfinityNumberComparatorHelper.infinityCheck(number, treatNanAs);
        if (infinity.isPresent()) {
            return infinity.getAsInt();
        }
        return Double.compare(number, value);
    }

    static int compareFloat(Float number, long value, OptionalInt treatNanAs) {
        OptionalInt infinity = InfinityNumberComparatorHelper.infinityCheck(number, treatNanAs);
        if (infinity.isPresent()) {
            return infinity.getAsInt();
        }
        return Float.compare(number.floatValue(), value);
    }

    private static int compareDouble(Double number, BigDecimal value, OptionalInt treatNanAs) {
        OptionalInt infinity = InfinityNumberComparatorHelper.infinityCheck(number, treatNanAs);
        if (infinity.isPresent()) {
            return infinity.getAsInt();
        }
        return BigDecimal.valueOf(number).compareTo(value);
    }

    private static int compareFloat(Float number, BigDecimal value, OptionalInt treatNanAs) {
        OptionalInt infinity = InfinityNumberComparatorHelper.infinityCheck(number, treatNanAs);
        if (infinity.isPresent()) {
            return infinity.getAsInt();
        }
        return BigDecimal.valueOf(number.floatValue()).compareTo(value);
    }
}

