/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation;

import io.avaje.validation.ConstraintViolation;
import io.avaje.validation.ConstraintViolationException;
import io.avaje.validation.adapter.ValidationAdapter;
import io.avaje.validation.adapter.ValidationContext;
import io.avaje.validation.core.DefaultBootstrap;
import io.avaje.validation.spi.AdapterFactory;
import io.avaje.validation.spi.AnnotationFactory;
import io.avaje.validation.spi.MessageInterpolator;
import io.avaje.validation.spi.ValidatorCustomizer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.Clock;
import java.time.Duration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

public interface Validator {
    public void validate(Object var1, Class<?> ... var2) throws ConstraintViolationException;

    public void validate(Object var1, @Nullable Locale var2, Class<?> ... var3) throws ConstraintViolationException;

    public Set<ConstraintViolation> check(Object var1, Class<?> ... var2);

    public Set<ConstraintViolation> check(Object var1, @Nullable Locale var2, Class<?> ... var3);

    public ValidationContext context();

    public static Builder builder() {
        return DefaultBootstrap.builder();
    }

    public static interface Builder {
        public <T> Builder add(Type var1, ValidationAdapter<T> var2);

        public <T> Builder add(Class<? extends Annotation> var1, ValidationAdapter<T> var2);

        public Builder addResourceBundles(String ... var1);

        public Builder addResourceBundles(ResourceBundle ... var1);

        public Builder setDefaultLocale(Locale var1);

        public Builder addLocales(Locale ... var1);

        public Builder clockProvider(Supplier<Clock> var1);

        public Builder temporalTolerance(Duration var1);

        public Builder messageInterpolator(MessageInterpolator var1);

        public Builder failFast(boolean var1);

        public Builder add(Type var1, AdapterBuilder var2);

        public Builder add(Class<? extends Annotation> var1, AnnotationAdapterBuilder var2);

        public Builder add(ValidatorCustomizer var1);

        public Builder add(AdapterFactory var1);

        public Builder add(AnnotationFactory var1);

        public Validator build();
    }

    @FunctionalInterface
    public static interface AnnotationAdapterBuilder {
        public ValidationAdapter<?> build(ValidationContext.AdapterCreateRequest var1);
    }

    @FunctionalInterface
    public static interface AdapterBuilder {
        public ValidationAdapter<?> build(ValidationContext var1);
    }
}

