/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.adapter;

import io.avaje.validation.adapter.ValidationAdapter;
import io.avaje.validation.adapter.ValidationRequest;

public abstract class ContainerAdapter<T>
implements ValidationAdapter<T> {
    protected final ValidationAdapter<T> initalAdapter;
    protected ValidationAdapter<Object> multiAdapter;

    protected ContainerAdapter(ValidationAdapter<T> initialAdapter) {
        this.initalAdapter = initialAdapter;
    }

    public ContainerAdapter<T> andThenMulti(ValidationAdapter<?> adapter) {
        this.multiAdapter = this.multiAdapter != null ? this.multiAdapter.andThen(adapter) : adapter;
        return this;
    }

    protected void validateAll(Iterable<Object> value, ValidationRequest req, String propertyName) {
        if (value == null || this.multiAdapter == null) {
            return;
        }
        if (propertyName != null) {
            req.pushPath(propertyName);
        }
        int index = 0;
        for (Object element : value) {
            this.multiAdapter.validate(element, req, "[" + index);
            ++index;
        }
        if (propertyName != null) {
            req.popPath();
        }
    }

    protected void validateArray(Object[] value, ValidationRequest req, String propertyName) {
        if (value == null || this.multiAdapter == null) {
            return;
        }
        if (propertyName != null) {
            req.pushPath(propertyName);
        }
        int index = 0;
        for (Object element : value) {
            this.multiAdapter.validate(element, req, "[" + index);
            ++index;
        }
        if (propertyName != null) {
            req.popPath();
        }
    }
}

