/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.core;

import io.avaje.validation.ConstraintViolation;
import io.avaje.validation.Validator;
import io.avaje.validation.adapter.ValidationAdapter;
import io.avaje.validation.adapter.ValidationContext;
import io.avaje.validation.adapter.ValidationRequest;
import io.avaje.validation.core.BasicMessageInterpolator;
import io.avaje.validation.core.CoreAdapterBuilder;
import io.avaje.validation.core.DMessage;
import io.avaje.validation.core.DRequest;
import io.avaje.validation.core.ExtensionLoader;
import io.avaje.validation.core.LocaleResolver;
import io.avaje.validation.core.NoOpValidator;
import io.avaje.validation.core.ResourceBundleManager;
import io.avaje.validation.core.TemplateLookup;
import io.avaje.validation.core.Util;
import io.avaje.validation.core.ValidationType;
import io.avaje.validation.spi.AdapterFactory;
import io.avaje.validation.spi.AnnotationFactory;
import io.avaje.validation.spi.GeneratedComponent;
import io.avaje.validation.spi.MessageInterpolator;
import io.avaje.validation.spi.ValidatorCustomizer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

final class DValidator
implements Validator,
ValidationContext {
    private static final ExtensionLoader SPI_LOADER = new ExtensionLoader();
    private final CoreAdapterBuilder builder;
    private final Map<Type, ValidationType<?>> typeCache = new ConcurrentHashMap();
    private final MessageInterpolator interpolator;
    private final LocaleResolver localeResolver;
    private final TemplateLookup templateLookup;
    private final Map<String, String> messageCache = new ConcurrentHashMap<String, String>();
    private final boolean failfast;

    DValidator(List<AdapterFactory> factories, List<AnnotationFactory> annotationFactories, List<String> bundleNames, List<ResourceBundle> bundles, MessageInterpolator interpolator, LocaleResolver localeResolver, Supplier<Clock> clockSupplier, Duration temporalTolerance, boolean failfast) {
        this.localeResolver = localeResolver;
        ResourceBundleManager defaultResourceBundle = new ResourceBundleManager(bundleNames, bundles, localeResolver);
        this.templateLookup = new TemplateLookup(defaultResourceBundle);
        this.interpolator = interpolator;
        this.builder = new CoreAdapterBuilder(this, factories, annotationFactories, clockSupplier, temporalTolerance);
        this.failfast = failfast;
    }

    MessageInterpolator interpolator() {
        return this.interpolator;
    }

    @Override
    public void validate(Object any, Class<?> ... groups) {
        this.validate(any, (Locale)null, groups);
    }

    @Override
    public void validate(Object any, @Nullable Locale locale, Class<?> ... groups) {
        ValidationType<?> type = this.type(any.getClass());
        type.validate(any, locale, List.of(groups));
    }

    @Override
    public Set<ConstraintViolation> check(Object any, Class<?> ... groups) {
        return this.check(any, (Locale)null, groups);
    }

    @Override
    public Set<ConstraintViolation> check(Object any, @Nullable Locale locale, Class<?> ... groups) {
        ValidationType<?> type = this.type(any.getClass());
        return type.check(any, locale, List.of(groups));
    }

    @Override
    public ValidationContext context() {
        return this;
    }

    private <T> ValidationType<T> type(Class<T> cls) {
        return this.typeWithCache(cls);
    }

    private <T> ValidationType<T> typeWithCache(Type type) {
        return this.typeCache.computeIfAbsent(type, k -> new ValidationType(this, this.adapter((Type)k)));
    }

    @Override
    public ValidationContext.Message message(Map<String, Object> attributes) {
        String keyOrTemplate = (String)attributes.get("message");
        return new DMessage(keyOrTemplate, attributes);
    }

    @Override
    public ValidationContext.Message message(String message, Map<String, Object> attributes) {
        return new DMessage(message, attributes);
    }

    @Override
    public <T> ValidationAdapter<T> adapter(Class<T> cls) {
        Type cacheKey = Util.canonicalizeClass(Objects.requireNonNull(cls));
        ValidationAdapter result = this.builder.get(cacheKey);
        if (result != null) {
            return result;
        }
        return this.builder.build(cacheKey);
    }

    @Override
    public <T> ValidationAdapter<T> adapter(Class<? extends Annotation> cls, Map<String, Object> attributes) {
        return this.builder.annotationAdapter(cls, attributes, null);
    }

    @Override
    public <T> ValidationAdapter<T> adapter(Class<? extends Annotation> cls, Set<Class<?>> groups, String message, Map<String, Object> attributes) {
        attributes = new HashMap<String, Object>(attributes);
        attributes.put("message", message);
        return this.builder.annotationAdapter(cls, Map.copyOf(attributes), groups);
    }

    @Override
    public <T> ValidationAdapter<T> adapter(Type type) {
        Type cacheKey = type = Util.removeSubtypeWildcard(Util.canonicalize(Objects.requireNonNull(type)));
        ValidationAdapter result = this.builder.get(cacheKey);
        if (result != null) {
            return result;
        }
        return this.builder.build(type, cacheKey);
    }

    @Override
    public <T> ValidationAdapter<T> noop() {
        return NoOpValidator.INSTANCE;
    }

    @Override
    public ValidationRequest request(@Nullable Locale locale, List<Class<?>> groups) {
        return new DRequest(this, this.failfast, locale, groups);
    }

    String interpolate(ValidationContext.Message msg, Locale requestLocale) {
        Locale locale = this.localeResolver.resolve(requestLocale);
        return this.messageCache.computeIfAbsent(msg.lookupkey() + String.valueOf(locale), k -> {
            String template = this.templateLookup.lookup(msg.template(), locale);
            return this.interpolator.interpolate(template, msg.attributes());
        });
    }

    static final class DBuilder
    implements Validator.Builder {
        private final List<AdapterFactory> factories = new ArrayList<AdapterFactory>();
        private final List<AnnotationFactory> afactories = new ArrayList<AnnotationFactory>();
        private final List<String> bundleNames = new ArrayList<String>();
        private final List<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        private final List<Locale> otherLocales = new ArrayList<Locale>();
        private Locale defaultLocale = Locale.getDefault();
        private Supplier<Clock> clockSupplier = Clock::systemDefaultZone;
        private Duration temporalTolerance = Duration.ZERO;
        private boolean failfast;
        private MessageInterpolator userInterpolator;

        DBuilder() {
        }

        @Override
        public Validator.Builder add(Type type, Validator.AdapterBuilder builder) {
            return this.add(DBuilder.newAdapterFactory(type, builder));
        }

        @Override
        public Validator.Builder add(Class<? extends Annotation> type, Validator.AnnotationAdapterBuilder builder) {
            return this.add(DBuilder.newAdapterFactory(type, builder));
        }

        @Override
        public <T> Validator.Builder add(Type type, ValidationAdapter<T> adapter) {
            return this.add(DBuilder.newAdapterFactory(type, adapter));
        }

        @Override
        public Validator.Builder add(ValidatorCustomizer component) {
            component.customize(this);
            return this;
        }

        @Override
        public Validator.Builder add(AdapterFactory factory) {
            this.factories.add(factory);
            return this;
        }

        @Override
        public <T> Validator.Builder add(Class<? extends Annotation> type, ValidationAdapter<T> adapter) {
            return this.add(DBuilder.newAnnotationAdapterFactory(type, adapter));
        }

        @Override
        public Validator.Builder add(AnnotationFactory factory) {
            this.afactories.add(factory);
            return this;
        }

        @Override
        public Validator.Builder addResourceBundles(String ... bundleName) {
            Collections.addAll(this.bundleNames, bundleName);
            return this;
        }

        @Override
        public Validator.Builder addResourceBundles(ResourceBundle ... bundle) {
            Collections.addAll(this.bundles, bundle);
            return this;
        }

        @Override
        public Validator.Builder setDefaultLocale(Locale defaultLocal) {
            this.defaultLocale = defaultLocal;
            return this;
        }

        @Override
        public Validator.Builder addLocales(Locale ... locals) {
            Collections.addAll(this.otherLocales, locals);
            return this;
        }

        @Override
        public Validator.Builder clockProvider(Supplier<Clock> clockSupplier) {
            this.clockSupplier = clockSupplier;
            return this;
        }

        @Override
        public Validator.Builder temporalTolerance(Duration temporalTolerance) {
            this.temporalTolerance = temporalTolerance;
            return this;
        }

        @Override
        public Validator.Builder failFast(boolean failfast) {
            this.failfast = failfast;
            return this;
        }

        @Override
        public Validator.Builder messageInterpolator(MessageInterpolator interpolator) {
            this.userInterpolator = interpolator;
            return this;
        }

        private void registerComponents() {
            for (ValidatorCustomizer validatorCustomizer : SPI_LOADER.customizers()) {
                validatorCustomizer.customize(this);
            }
            for (GeneratedComponent generatedComponent : SPI_LOADER.generatedComponents()) {
                generatedComponent.customize(this);
            }
        }

        @Override
        public DValidator build() {
            this.registerComponents();
            LocaleResolver localeResolver = new LocaleResolver(this.defaultLocale, this.otherLocales);
            MessageInterpolator interpolator = Optional.ofNullable(this.userInterpolator).or(SPI_LOADER::interpolator).orElseGet(BasicMessageInterpolator::new);
            return new DValidator(this.factories, this.afactories, this.bundleNames, this.bundles, interpolator, localeResolver, this.clockSupplier, this.temporalTolerance, this.failfast);
        }

        private static <T> AnnotationFactory newAnnotationAdapterFactory(Type type, ValidationAdapter<T> adapter) {
            Objects.requireNonNull(type);
            Objects.requireNonNull(adapter);
            return request -> DBuilder.simpleMatch(type, request.annotationType()) ? adapter : null;
        }

        private static <T> AdapterFactory newAdapterFactory(Type type, ValidationAdapter<T> adapter) {
            Objects.requireNonNull(type);
            Objects.requireNonNull(adapter);
            return (targetType, context) -> DBuilder.simpleMatch(type, targetType) ? adapter : null;
        }

        private static AdapterFactory newAdapterFactory(Type type, Validator.AdapterBuilder builder) {
            Objects.requireNonNull(type);
            Objects.requireNonNull(builder);
            return (targetType, ctx) -> DBuilder.simpleMatch(type, targetType) ? builder.build(ctx) : null;
        }

        private static AnnotationFactory newAdapterFactory(Class<? extends Annotation> type, Validator.AnnotationAdapterBuilder builder) {
            Objects.requireNonNull(type);
            Objects.requireNonNull(builder);
            return req -> DBuilder.simpleMatch(type, req.annotationType()) ? builder.build(req) : null;
        }

        private static boolean simpleMatch(Type type, Type targetType) {
            return Util.typesMatch(type, targetType);
        }
    }
}

