/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.core;

import io.avaje.validation.spi.AdapterFactory;
import io.avaje.validation.spi.AnnotationFactory;
import io.avaje.validation.spi.GeneratedComponent;
import io.avaje.validation.spi.MessageInterpolator;
import io.avaje.validation.spi.ValidationExtension;
import io.avaje.validation.spi.ValidatorCustomizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;

final class ExtensionLoader {
    private final List<GeneratedComponent> generatedComponents = new ArrayList<GeneratedComponent>();
    private final List<ValidatorCustomizer> customizers = new ArrayList<ValidatorCustomizer>();
    private final List<AdapterFactory> adapterFactories = new ArrayList<AdapterFactory>();
    private final List<AnnotationFactory> annotationFactories = new ArrayList<AnnotationFactory>();
    private Optional<MessageInterpolator> interpolator = Optional.empty();

    ExtensionLoader() {
        for (ValidationExtension spi : ServiceLoader.load(ValidationExtension.class)) {
            if (spi instanceof GeneratedComponent) {
                GeneratedComponent gc = (GeneratedComponent)spi;
                this.generatedComponents.add(gc);
                continue;
            }
            if (spi instanceof ValidatorCustomizer) {
                ValidatorCustomizer c = (ValidatorCustomizer)spi;
                this.customizers.add(c);
                continue;
            }
            if (spi instanceof MessageInterpolator) {
                MessageInterpolator m = (MessageInterpolator)spi;
                this.interpolator = Optional.of(m);
                continue;
            }
            if (spi instanceof AdapterFactory) {
                AdapterFactory af = (AdapterFactory)spi;
                this.adapterFactories.add(af);
                continue;
            }
            if (!(spi instanceof AnnotationFactory)) continue;
            AnnotationFactory af = (AnnotationFactory)spi;
            this.annotationFactories.add(af);
        }
    }

    Optional<MessageInterpolator> interpolator() {
        return this.interpolator;
    }

    List<GeneratedComponent> generatedComponents() {
        return this.generatedComponents;
    }

    List<ValidatorCustomizer> customizers() {
        return this.customizers;
    }

    List<AdapterFactory> adapterFactories() {
        return this.adapterFactories;
    }

    List<AnnotationFactory> annotationFactories() {
        return this.annotationFactories;
    }
}

