/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jspecify.annotations.Nullable;

final class LocaleResolver {
    private final Locale defaultLocale;
    private final Set<Locale> otherLocales = new HashSet<Locale>();

    LocaleResolver(Locale defaultLocale, Collection<Locale> others) {
        this.defaultLocale = defaultLocale;
        this.otherLocales.addAll(others);
    }

    public Locale defaultLocale() {
        return this.defaultLocale;
    }

    public Set<Locale> otherLocales() {
        return this.otherLocales;
    }

    public Locale resolve(@Nullable Locale requestLocale) {
        if (requestLocale == null || !this.otherLocales.contains(requestLocale)) {
            return this.defaultLocale;
        }
        return requestLocale;
    }
}

