/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.core;

import io.avaje.applog.AppLog;
import io.avaje.validation.core.LocaleResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jspecify.annotations.Nullable;

final class ResourceBundleManager {
    private static final System.Logger logger = AppLog.getLogger(ResourceBundleManager.class);
    private final Map<Locale, List<ResourceBundle>> map = new HashMap<Locale, List<ResourceBundle>>();
    private static final List<ResourceBundle> EMPTY = List.of();
    private static final String DEFAULT_BUNDLE = "io.avaje.validation.Messages";

    ResourceBundleManager(List<String> names, List<ResourceBundle> providedBundles, LocaleResolver localeResolver) {
        for (String name : names) {
            this.addBundle(name, localeResolver.defaultLocale());
            for (Locale locale : localeResolver.otherLocales()) {
                this.addBundle(name, locale);
            }
        }
        for (ResourceBundle bundle : providedBundles) {
            this.map.computeIfAbsent(bundle.getLocale(), key -> new ArrayList()).add(bundle);
        }
        this.addBundle(DEFAULT_BUNDLE, localeResolver.defaultLocale());
        for (Locale locale : localeResolver.otherLocales()) {
            this.addBundle(DEFAULT_BUNDLE, locale);
        }
    }

    private void addBundle(String name, Locale locale) {
        try {
            this.map.computeIfAbsent(locale, key -> new ArrayList()).add(ResourceBundle.getBundle(name, locale));
        }
        catch (MissingResourceException e) {
            logger.log(System.Logger.Level.ERROR, "failed to load " + name + " with locale " + String.valueOf(locale));
        }
    }

    public @Nullable String message(String template, Locale resolvedLocale) {
        for (ResourceBundle bundle : this.map.getOrDefault(resolvedLocale, EMPTY)) {
            if (!bundle.containsKey(template)) continue;
            return bundle.getString(template);
        }
        return null;
    }
}

