/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.core;

import io.avaje.validation.ConstraintViolation;
import io.avaje.validation.ConstraintViolationException;
import io.avaje.validation.adapter.ValidationAdapter;
import io.avaje.validation.adapter.ValidationContext;
import io.avaje.validation.adapter.ValidationRequest;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jspecify.annotations.Nullable;

final class ValidationType<T> {
    private final ValidationContext ctx;
    private final ValidationAdapter<T> adapter;

    ValidationType(ValidationContext validator, ValidationAdapter<T> adapter) {
        this.ctx = validator;
        this.adapter = adapter;
    }

    void validate(T object, @Nullable Locale locale, List<Class<?>> groups) throws ConstraintViolationException {
        this.executeValidations(object, locale, groups).throwWithViolations();
    }

    Set<ConstraintViolation> check(T object, @Nullable Locale locale, List<Class<?>> groups) {
        return this.executeValidations(object, locale, groups).violations();
    }

    private ValidationRequest executeValidations(T object, Locale locale, List<Class<?>> groups) {
        ValidationRequest req = this.ctx.request(locale, groups);
        this.adapter.validate(object, req);
        return req;
    }
}

