/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.core.adapters;

import io.avaje.validation.adapter.AbstractConstraintAdapter;
import io.avaje.validation.adapter.ValidationContext;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAmount;

final class DateRangeAdapter
extends AbstractConstraintAdapter<Object> {
    private final Clock referenceClock;
    private final Duration tolerance;
    private final String _type;
    private final TemporalAmount min;
    private final TemporalAmount max;

    DateRangeAdapter(ValidationContext.AdapterCreateRequest request, Clock referenceClock, Duration tolerance) {
        super(request);
        this.referenceClock = referenceClock;
        this.tolerance = tolerance;
        this._type = request.targetType();
        this.min = this.parsePeriod((String)request.attribute("min"), true);
        this.max = this.parsePeriod((String)request.attribute("max"), false);
    }

    private TemporalAmount parsePeriod(String period, boolean negateTolerance) {
        if (period == null || period.isEmpty()) {
            return null;
        }
        if ("now".equals(period)) {
            return this.nowTolerance(negateTolerance);
        }
        try {
            return Period.parse(period);
        }
        catch (DateTimeParseException e) {
            return Duration.parse(period);
        }
    }

    private TemporalAmount nowTolerance(boolean negateTolerance) {
        return switch (this._type) {
            case "Temporal.Instant", "Temporal.LocalDateTime", "Temporal.ZonedDateTime", "Temporal.OffsetDateTime" -> {
                if (negateTolerance) {
                    yield this.tolerance.negated();
                }
                yield this.tolerance;
            }
            default -> Period.ZERO;
        };
    }

    @Override
    protected boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        return switch (this._type) {
            case "Temporal.Instant" -> this.compare((Instant)value);
            case "Temporal.LocalDate" -> this.compare((LocalDate)value);
            case "Temporal.LocalDateTime" -> this.compare((LocalDateTime)value);
            case "Temporal.LocalTime" -> this.compare((LocalTime)value);
            case "Temporal.ZonedDateTime" -> this.compare((ZonedDateTime)value);
            case "Temporal.OffsetDateTime" -> this.compare((OffsetDateTime)value);
            case "Temporal.OffsetTime" -> this.compare((OffsetTime)value);
            case "Temporal.Year" -> this.compare((Year)value);
            case "Temporal.YearMonth" -> this.compare((YearMonth)value);
            default -> throw new IllegalStateException("Unsupported type " + this._type);
        };
    }

    private boolean compare(LocalDate value) {
        LocalDate now = LocalDate.now(this.referenceClock);
        if (this.min != null && now.plus(this.min).isAfter(value)) {
            return false;
        }
        return this.max == null || !now.plus(this.max).isBefore(value);
    }

    private boolean compare(LocalDateTime value) {
        LocalDateTime now = LocalDateTime.now(this.referenceClock);
        if (this.min != null && now.plus(this.min).isAfter(value)) {
            return false;
        }
        return this.max == null || !now.plus(this.max).isBefore(value);
    }

    private boolean compare(LocalTime value) {
        LocalTime now = LocalTime.now(this.referenceClock);
        if (this.min != null && now.plus(this.min).isAfter(value)) {
            return false;
        }
        return this.max == null || !now.plus(this.max).isBefore(value);
    }

    private boolean compare(Instant value) {
        Instant now = Instant.now(this.referenceClock);
        if (this.min != null && now.plus(this.min).isAfter(value)) {
            return false;
        }
        return this.max == null || !now.plus(this.max).isBefore(value);
    }

    private boolean compare(ZonedDateTime value) {
        ZonedDateTime now = ZonedDateTime.now(this.referenceClock);
        if (this.min != null && now.plus(this.min).isAfter(value)) {
            return false;
        }
        return this.max == null || !now.plus(this.max).isBefore(value);
    }

    private boolean compare(OffsetDateTime value) {
        OffsetDateTime now = OffsetDateTime.now(this.referenceClock);
        if (this.min != null && now.plus(this.min).isAfter(value)) {
            return false;
        }
        return this.max == null || !now.plus(this.max).isBefore(value);
    }

    private boolean compare(OffsetTime value) {
        OffsetTime now = OffsetTime.now(this.referenceClock);
        if (this.min != null && now.plus(this.min).isAfter(value)) {
            return false;
        }
        return this.max == null || !now.plus(this.max).isBefore(value);
    }

    private boolean compare(Year value) {
        Year now = Year.now(this.referenceClock);
        if (this.min != null && now.plus(this.min).isAfter(value)) {
            return false;
        }
        return this.max == null || !now.plus(this.max).isBefore(value);
    }

    private boolean compare(YearMonth value) {
        YearMonth now = YearMonth.now(this.referenceClock);
        if (this.min != null && now.plus(this.min).isAfter(value)) {
            return false;
        }
        return this.max == null || !now.plus(this.max).isBefore(value);
    }
}

