/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.core.adapters;

import io.avaje.validation.adapter.AbstractConstraintAdapter;
import io.avaje.validation.adapter.ValidationContext;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.function.Function;

final class FuturePastAdapter
extends AbstractConstraintAdapter<Object> {
    private final boolean past;
    private final boolean includePresent;
    private final Clock referenceClock;
    private final String _type;

    FuturePastAdapter(ValidationContext.AdapterCreateRequest request, boolean past, boolean includePresent, Clock referenceClock) {
        super(request);
        this.past = past;
        this.includePresent = includePresent;
        this.referenceClock = referenceClock;
        this._type = request.targetType();
    }

    @Override
    public boolean isValid(Object obj) {
        if (obj == null) {
            return true;
        }
        return switch (this._type) {
            case "Temporal.Date" -> this.compare(Long.valueOf(((Date)obj).getTime()), Clock::millis);
            case "Temporal.Instant" -> this.compare((Instant)obj, Instant::now);
            case "Temporal.LocalDate" -> this.compare((LocalDate)obj, LocalDate::now);
            case "Temporal.LocalDateTime" -> this.compare((LocalDateTime)obj, LocalDateTime::now);
            case "Temporal.LocalTime" -> this.compare((LocalTime)obj, LocalTime::now);
            case "Temporal.ZonedDateTime" -> this.compare((ZonedDateTime)obj, ZonedDateTime::now);
            case "Temporal.OffsetDateTime" -> this.compare((OffsetDateTime)obj, OffsetDateTime::now);
            case "Temporal.OffsetTime" -> this.compare((OffsetTime)obj, OffsetTime::now);
            case "Temporal.Year" -> this.compare((Year)obj, Year::now);
            case "Temporal.YearMonth" -> this.compare((YearMonth)obj, YearMonth::now);
            default -> throw new IllegalStateException("Unsupported type " + this._type);
        };
    }

    private <T> boolean compare(Comparable<T> instant, Function<Clock, T> nowFunction) {
        T now = nowFunction.apply(this.referenceClock);
        int result = instant.compareTo(now);
        if (this.includePresent && result == 0) {
            return true;
        }
        if (result == 0) {
            return false;
        }
        return this.past ? result < 0 : result > 0;
    }
}

