/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.core.adapters;

import io.avaje.validation.adapter.ValidationAdapter;
import io.avaje.validation.adapter.ValidationContext;
import io.avaje.validation.core.adapters.DateRangeAdapter;
import io.avaje.validation.core.adapters.FuturePastAdapter;
import io.avaje.validation.spi.AnnotationFactory;
import java.time.Clock;
import java.time.Duration;
import java.util.function.Supplier;

public final class FuturePastAdapterFactory
implements AnnotationFactory {
    private final Supplier<Clock> clockSupplier;
    private final Duration tolerance;
    private Clock pastClock;
    private Clock futureClock;

    public FuturePastAdapterFactory(Supplier<Clock> clockSupplier, Duration tolerance) {
        this.clockSupplier = clockSupplier;
        this.tolerance = tolerance;
    }

    @Override
    public ValidationAdapter<?> create(ValidationContext.AdapterCreateRequest request) {
        return switch (request.annotationType().getSimpleName()) {
            case "DateRange" -> new DateRangeAdapter(request, this.clockSupplier.get(), this.tolerance);
            case "Past" -> new FuturePastAdapter(request, true, false, this.pastClock());
            case "PastOrPresent" -> new FuturePastAdapter(request, true, true, this.pastClock());
            case "Future" -> new FuturePastAdapter(request, false, false, this.futureClock());
            case "FutureOrPresent" -> new FuturePastAdapter(request, false, true, this.futureClock());
            default -> null;
        };
    }

    private Clock pastClock() {
        if (this.pastClock == null) {
            this.pastClock = Clock.offset(this.clockSupplier.get(), this.tolerance);
        }
        return this.pastClock;
    }

    private Clock futureClock() {
        if (this.futureClock == null) {
            this.futureClock = Clock.offset(this.clockSupplier.get(), this.tolerance.negated());
        }
        return this.futureClock;
    }
}

