/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.core.adapters;

import io.avaje.validation.adapter.AbstractConstraintAdapter;
import io.avaje.validation.adapter.PrimitiveAdapter;
import io.avaje.validation.adapter.ValidationAdapter;
import io.avaje.validation.adapter.ValidationContext;
import io.avaje.validation.core.adapters.InfinityNumberComparatorHelper;
import io.avaje.validation.core.adapters.NumberComparatorHelper;
import io.avaje.validation.core.adapters.NumberSignHelper;
import io.avaje.validation.spi.AnnotationFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.Optional;

public final class NumberAdapters {
    public static final AnnotationFactory FACTORY = request -> switch (request.annotationType().getSimpleName()) {
        case "Digits" -> new DigitsAdapter(request);
        case "Positive" -> new PositiveAdapter(request, false);
        case "PositiveOrZero" -> new PositiveAdapter(request, true);
        case "Negative" -> new NegativeAdapter(request, false);
        case "NegativeOrZero" -> new NegativeAdapter(request, true);
        case "Max" -> NumberAdapters.max(request);
        case "Min" -> NumberAdapters.min(request);
        case "DecimalMax" -> new DecimalMaxAdapter(request);
        case "DecimalMin" -> new DecimalMinAdapter(request);
        case "Range" -> NumberAdapters.range(request);
        default -> null;
    };
    public static final String VALUE = "value";

    private NumberAdapters() {
    }

    private static ValidationAdapter<?> range(ValidationContext.AdapterCreateRequest request) {
        if ("String".equals(request.targetType())) {
            return new RangeStringAdapter(request);
        }
        return new RangeAdapter(request);
    }

    private static AbstractConstraintAdapter<? extends Number> max(ValidationContext.AdapterCreateRequest request) {
        return switch (request.targetType()) {
            case "BigDecimal" -> new MaxBigDecimal(request);
            case "BigInteger" -> new MaxBigInteger(request);
            default -> new MaxAdapter(request);
        };
    }

    private static AbstractConstraintAdapter<? extends Number> min(ValidationContext.AdapterCreateRequest request) {
        String targetType;
        return switch (targetType = request.targetType()) {
            case "BigDecimal" -> new MinBigDecimal(request);
            case "BigInteger" -> new MinBigInteger(request);
            default -> new MinAdapter(request);
        };
    }

    private static final class RangeStringAdapter
    extends AbstractConstraintAdapter<Object> {
        private final BigDecimal min;
        private final BigDecimal max;

        RangeStringAdapter(ValidationContext.AdapterCreateRequest request) {
            super(request);
            this.min = BigDecimal.valueOf((Long)request.attribute("min"));
            this.max = BigDecimal.valueOf((Long)request.attribute("max"));
        }

        @Override
        public boolean isValid(Object value) {
            if (value == null) {
                return true;
            }
            BigDecimal decimal = new BigDecimal(value.toString());
            return this.min.compareTo(decimal) <= 0 && this.max.compareTo(decimal) >= 0;
        }
    }

    private static final class RangeAdapter
    extends PrimitiveAdapter<Number> {
        private final NumberAdapter<Number> maxAdapter;
        private final NumberAdapter<Number> minAdapter;
        private final long min;
        private final long max;

        RangeAdapter(ValidationContext.AdapterCreateRequest request) {
            super(request);
            this.min = (Long)request.attribute("min");
            this.max = (Long)request.attribute("max");
            this.maxAdapter = (NumberAdapter)((Object)NumberAdapters.max(request.withValue(this.max)));
            this.minAdapter = (NumberAdapter)((Object)NumberAdapters.min(request.withValue(this.min)));
        }

        @Override
        public boolean isValid(Number value) {
            if (value == null) {
                return true;
            }
            return this.minAdapter.isValid(value) && this.maxAdapter.isValid(value);
        }

        @Override
        public boolean isValid(byte value) {
            return (long)value >= this.min && (long)value <= this.max;
        }

        @Override
        public boolean isValid(double value) {
            return value >= (double)this.min && value <= (double)this.max;
        }

        @Override
        public boolean isValid(float value) {
            return value >= (float)this.min && value <= (float)this.max;
        }

        @Override
        public boolean isValid(int value) {
            return (long)value >= this.min && (long)value <= this.max;
        }

        @Override
        public boolean isValid(long value) {
            return value >= this.min && value <= this.max;
        }

        @Override
        public boolean isValid(short value) {
            return (long)value >= this.min && (long)value <= this.max;
        }
    }

    static final class MaxBigDecimal
    extends AbstractConstraintAdapter<BigDecimal>
    implements NumberAdapter<BigDecimal> {
        private final BigDecimal max;

        MaxBigDecimal(ValidationContext.AdapterCreateRequest request) {
            super(request);
            this.max = new BigDecimal(String.valueOf(request.attribute(NumberAdapters.VALUE)));
        }

        @Override
        public boolean isValid(BigDecimal number) {
            return number == null || number.compareTo(this.max) <= 0;
        }
    }

    static final class MaxBigInteger
    extends AbstractConstraintAdapter<BigInteger>
    implements NumberAdapter<BigInteger> {
        private final BigInteger max;

        MaxBigInteger(ValidationContext.AdapterCreateRequest request) {
            super(request);
            this.max = new BigInteger(String.valueOf(request.attribute(NumberAdapters.VALUE)));
        }

        @Override
        public boolean isValid(BigInteger number) {
            return number == null || number.compareTo(this.max) <= 0;
        }
    }

    private static final class MaxAdapter
    extends PrimitiveAdapter<Number>
    implements NumberAdapter<Number> {
        private final long max;
        private final String targetType;

        MaxAdapter(ValidationContext.AdapterCreateRequest request) {
            super(request);
            this.targetType = request.targetType();
            this.max = (Long)request.attribute(NumberAdapters.VALUE);
        }

        @Override
        public boolean isValid(Number number) {
            if (number == null) {
                return true;
            }
            return switch (this.targetType) {
                case "Integer", "Long", "Short", "Byte" -> {
                    if (number.longValue() <= this.max) {
                        yield true;
                    }
                    yield false;
                }
                case "Double", "Number" -> {
                    if (NumberComparatorHelper.compareDouble((Double)number.doubleValue(), this.max, InfinityNumberComparatorHelper.GREATER_THAN) <= 0) {
                        yield true;
                    }
                    yield false;
                }
                case "Float" -> {
                    if (NumberComparatorHelper.compareFloat((Float)number, this.max, InfinityNumberComparatorHelper.GREATER_THAN) <= 0) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw new IllegalStateException();
            };
        }

        @Override
        public boolean isValid(byte value) {
            return (long)value <= this.max;
        }

        @Override
        public boolean isValid(double value) {
            return value <= (double)this.max;
        }

        @Override
        public boolean isValid(float value) {
            return value <= (float)this.max;
        }

        @Override
        public boolean isValid(int value) {
            return (long)value <= this.max;
        }

        @Override
        public boolean isValid(long value) {
            return value <= this.max;
        }

        @Override
        public boolean isValid(short value) {
            return (long)value <= this.max;
        }
    }

    static final class MinBigDecimal
    extends AbstractConstraintAdapter<BigDecimal>
    implements NumberAdapter<BigDecimal> {
        private final BigDecimal min;

        MinBigDecimal(ValidationContext.AdapterCreateRequest request) {
            super(request);
            this.min = new BigDecimal(String.valueOf(request.attribute(NumberAdapters.VALUE)));
        }

        @Override
        public boolean isValid(BigDecimal number) {
            return number == null || number.compareTo(this.min) >= 0;
        }
    }

    static final class MinBigInteger
    extends AbstractConstraintAdapter<BigInteger>
    implements NumberAdapter<BigInteger> {
        private final BigInteger min;

        MinBigInteger(ValidationContext.AdapterCreateRequest request) {
            super(request);
            this.min = new BigInteger(String.valueOf(request.attribute(NumberAdapters.VALUE)));
        }

        @Override
        public boolean isValid(BigInteger number) {
            return number == null || number.compareTo(this.min) >= 0;
        }
    }

    private static final class MinAdapter
    extends PrimitiveAdapter<Number>
    implements NumberAdapter<Number> {
        private final long min;
        private final String targetType;

        MinAdapter(ValidationContext.AdapterCreateRequest request) {
            super(request);
            this.targetType = request.targetType();
            this.min = (Long)request.attribute(NumberAdapters.VALUE);
        }

        @Override
        public boolean isValid(Number number) {
            if (number == null) {
                return true;
            }
            return switch (this.targetType) {
                case "Integer", "Long", "Short", "Byte" -> {
                    if (number.longValue() >= this.min) {
                        yield true;
                    }
                    yield false;
                }
                case "Double" -> {
                    if (NumberComparatorHelper.compareDouble((Double)number.doubleValue(), this.min, InfinityNumberComparatorHelper.LESS_THAN) >= 0) {
                        yield true;
                    }
                    yield false;
                }
                case "Float" -> {
                    if (NumberComparatorHelper.compareFloat((Float)number, this.min, InfinityNumberComparatorHelper.LESS_THAN) >= 0) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw new IllegalStateException();
            };
        }

        @Override
        public boolean isValid(byte value) {
            return (long)value >= this.min;
        }

        @Override
        public boolean isValid(double value) {
            return value >= (double)this.min;
        }

        @Override
        public boolean isValid(float value) {
            return value >= (float)this.min;
        }

        @Override
        public boolean isValid(int value) {
            return (long)value >= this.min;
        }

        @Override
        public boolean isValid(long value) {
            return value >= this.min;
        }

        @Override
        public boolean isValid(short value) {
            return (long)value >= this.min;
        }
    }

    private static final class DigitsAdapter
    extends AbstractConstraintAdapter<Object> {
        private final int integer;
        private final int fraction;

        DigitsAdapter(ValidationContext.AdapterCreateRequest request) {
            super(request);
            this.integer = (Integer)request.attribute("integer");
            this.fraction = (Integer)request.attribute("fraction");
        }

        @Override
        public boolean isValid(Object value) {
            BigDecimal bd;
            if (value == null) {
                return true;
            }
            BigDecimal bigNum = value instanceof BigDecimal ? (bd = (BigDecimal)value) : NumberSignHelper.toBigDecimal(value.toString()).stripTrailingZeros();
            int integerPartLength = bigNum.precision() - bigNum.scale();
            int fractionPartLength = Math.max(bigNum.scale(), 0);
            return this.integer >= integerPartLength && this.fraction >= fractionPartLength;
        }
    }

    private static final class PositiveAdapter
    extends PrimitiveAdapter<Object> {
        private final boolean inclusive;
        private final String targetType;

        PositiveAdapter(ValidationContext.AdapterCreateRequest request, boolean inclusive) {
            super(request);
            this.inclusive = inclusive;
            this.targetType = request.targetType();
        }

        @Override
        public boolean isValid(Object value) {
            if (value == null) {
                return true;
            }
            int sign = NumberSignHelper.signum(this.targetType, value, InfinityNumberComparatorHelper.LESS_THAN);
            return !(!this.inclusive ? sign <= 0 : sign < 0);
        }

        @Override
        public boolean isValid(byte value) {
            return this.inclusive ? value >= 0 : value > 0;
        }

        @Override
        public boolean isValid(double value) {
            return this.inclusive ? value >= 0.0 : value > 0.0;
        }

        @Override
        public boolean isValid(float value) {
            return this.inclusive ? value >= 0.0f : value > 0.0f;
        }

        @Override
        public boolean isValid(int value) {
            return this.inclusive ? value >= 0 : value > 0;
        }

        @Override
        public boolean isValid(long value) {
            return this.inclusive ? value >= 0L : value > 0L;
        }

        @Override
        public boolean isValid(short value) {
            return this.inclusive ? value >= 0 : value > 0;
        }
    }

    private static final class NegativeAdapter
    extends PrimitiveAdapter<Object> {
        private final boolean inclusive;
        private final String targetType;

        NegativeAdapter(ValidationContext.AdapterCreateRequest request, boolean inclusive) {
            super(request);
            this.inclusive = inclusive;
            this.targetType = request.targetType();
        }

        @Override
        public boolean isValid(Object value) {
            if (value == null) {
                return true;
            }
            int sign = NumberSignHelper.signum(this.targetType, value, InfinityNumberComparatorHelper.GREATER_THAN);
            return !(!this.inclusive ? sign >= 0 : sign > 0);
        }

        @Override
        public boolean isValid(byte value) {
            return this.inclusive ? value <= 0 : value < 0;
        }

        @Override
        public boolean isValid(double value) {
            return this.inclusive ? value <= 0.0 : value < 0.0;
        }

        @Override
        public boolean isValid(float value) {
            return this.inclusive ? value <= 0.0f : value < 0.0f;
        }

        @Override
        public boolean isValid(int value) {
            return this.inclusive ? value <= 0 : value < 0;
        }

        @Override
        public boolean isValid(long value) {
            return this.inclusive ? value <= 0L : value < 0L;
        }

        @Override
        public boolean isValid(short value) {
            return this.inclusive ? value <= 0 : value < 0;
        }
    }

    private static final class DecimalMaxAdapter
    extends AbstractConstraintAdapter<Object> {
        private final BigDecimal value;
        private final boolean inclusive;
        private final String targetType;

        DecimalMaxAdapter(ValidationContext.AdapterCreateRequest request) {
            super(request);
            Map<String, Object> attributes = request.attributes();
            this.value = new BigDecimal((String)attributes.get(NumberAdapters.VALUE));
            this.inclusive = Optional.ofNullable((Boolean)attributes.get("inclusive")).orElse(true);
            this.targetType = request.targetType();
        }

        @Override
        public boolean isValid(Object number) {
            if (number == null) {
                return true;
            }
            int comparisonResult = NumberComparatorHelper.compareDecimal(this.targetType, number, this.value, InfinityNumberComparatorHelper.LESS_THAN);
            return !(!this.inclusive ? comparisonResult >= 0 : comparisonResult > 0);
        }
    }

    private static final class DecimalMinAdapter
    extends AbstractConstraintAdapter<Object> {
        private final BigDecimal value;
        private final boolean inclusive;
        private final String targetType;

        DecimalMinAdapter(ValidationContext.AdapterCreateRequest request) {
            super(request);
            Map<String, Object> attributes = request.attributes();
            this.value = new BigDecimal((String)attributes.get(NumberAdapters.VALUE));
            this.inclusive = Optional.ofNullable((Boolean)attributes.get("inclusive")).orElse(true);
            this.targetType = request.targetType();
        }

        @Override
        public boolean isValid(Object number) {
            if (number == null) {
                return true;
            }
            int comparisonResult = NumberComparatorHelper.compareDecimal(this.targetType, number, this.value, InfinityNumberComparatorHelper.LESS_THAN);
            return !(!this.inclusive ? comparisonResult <= 0 : comparisonResult < 0);
        }
    }

    public static interface NumberAdapter<T extends Number> {
        public boolean isValid(T var1);
    }
}

