/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.core.adapters;

import io.avaje.validation.core.adapters.InfinityNumberComparatorHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.OptionalInt;

final class NumberSignHelper {
    private static final short SHORT_ZERO = 0;
    private static final float FLOAT_ZERO = 0.0f;
    private static final double DOUBLE_ZERO = 0.0;
    private static final byte BYTE_ZERO = 0;

    private NumberSignHelper() {
    }

    static BigDecimal toBigDecimal(Object value) {
        try {
            return new BigDecimal(value.toString());
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Object: " + String.valueOf(value) + " Is not a valid number", nfe);
        }
    }

    static int signum(String targetType, Object value, OptionalInt treatNanAs) {
        if (targetType == null) {
            return Double.compare(((Number)value).doubleValue(), 0.0);
        }
        return switch (targetType) {
            case "String", "CharSequence" -> NumberSignHelper.toBigDecimal(value).signum();
            case "BigDecimal" -> ((BigDecimal)value).signum();
            case "BigInteger" -> ((BigInteger)value).signum();
            case "Byte" -> ((Byte)value).compareTo((byte)0);
            case "Short" -> ((Short)value).compareTo((short)0);
            case "Integer" -> Integer.signum((Integer)value);
            case "Long" -> Long.signum((Long)value);
            case "Float" -> NumberSignHelper.signum((Float)value, treatNanAs);
            case "Double" -> NumberSignHelper.signum((Double)value, treatNanAs);
            default -> Double.compare(((Number)value).doubleValue(), 0.0);
        };
    }

    static int signum(Float number, OptionalInt treatNanAs) {
        OptionalInt infinity = InfinityNumberComparatorHelper.infinityCheck(number, treatNanAs);
        if (infinity.isPresent()) {
            return infinity.getAsInt();
        }
        return number.compareTo(Float.valueOf(0.0f));
    }

    static int signum(Double number, OptionalInt treatNanAs) {
        OptionalInt infinity = InfinityNumberComparatorHelper.infinityCheck(number, treatNanAs);
        if (infinity.isPresent()) {
            return infinity.getAsInt();
        }
        return number.compareTo(0.0);
    }
}

