/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.core.adapters;

import io.avaje.validation.adapter.AbstractConstraintAdapter;
import io.avaje.validation.adapter.ValidationContext;
import io.avaje.validation.core.adapters.BasicAdapters;
import java.net.URI;

final class UriAdapter
extends AbstractConstraintAdapter<Object> {
    private final String scheme;
    private final String host;
    private final int port;
    private final BasicAdapters.PatternAdapter patternAdapter;

    UriAdapter(ValidationContext.AdapterCreateRequest request) {
        super(request);
        this.scheme = (String)request.attribute("scheme");
        this.host = (String)request.attribute("host");
        this.port = (Integer)request.attribute("port");
        String regexp = (String)request.attribute("regexp");
        this.patternAdapter = !regexp.isEmpty() ? new BasicAdapters.PatternAdapter(request) : null;
    }

    @Override
    protected boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        try {
            String stringValue = String.valueOf(value);
            URI uri = URI.create(stringValue);
            if (!this.scheme.isEmpty() && !this.scheme.equals(uri.getScheme()) || !this.host.isEmpty() && !this.host.equals(uri.getHost())) {
                return false;
            }
            if (this.port > -1 && this.port != uri.getPort()) {
                return false;
            }
            return this.patternAdapter == null || this.patternAdapter.isValid(stringValue);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

