/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.classpath.scanner.core;

import io.avaje.classpath.scanner.ClassFilter;
import io.avaje.classpath.scanner.ClassPathScanner;
import io.avaje.classpath.scanner.Resource;
import io.avaje.classpath.scanner.ResourceFilter;
import io.avaje.classpath.scanner.core.Location;
import io.avaje.classpath.scanner.internal.EnvironmentDetection;
import io.avaje.classpath.scanner.internal.ResourceAndClassScanner;
import io.avaje.classpath.scanner.internal.scanner.classpath.android.AndroidScanner;
import io.avaje.classpath.scanner.internal.scanner.filesystem.FileSystemScanner;
import java.util.List;

public class Scanner
implements ClassPathScanner {
    private final ResourceAndClassScanner resourceAndClassScanner;
    private final FileSystemScanner fileSystemScanner = new FileSystemScanner();

    public Scanner(ClassLoader classLoader) {
        this.resourceAndClassScanner = EnvironmentDetection.isAndroid() ? new AndroidScanner(classLoader) : new io.avaje.classpath.scanner.internal.scanner.classpath.ClassPathScanner(classLoader);
    }

    public List<Resource> scanForResources(Location location, ResourceFilter predicate) {
        if (location.isFileSystem()) {
            return this.fileSystemScanner.scanForResources(location, predicate);
        }
        return this.resourceAndClassScanner.scanForResources(location, predicate);
    }

    public List<Resource> scanForResources(String location, ResourceFilter predicate) {
        return this.scanForResources(new Location(location), predicate);
    }

    public List<Class<?>> scanForClasses(Location location, ClassFilter predicate) {
        return this.resourceAndClassScanner.scanForClasses(location, predicate);
    }

    public List<Class<?>> scanForClasses(String location, ClassFilter predicate) {
        return this.scanForClasses(new Location(location), predicate);
    }
}

