/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config.load;

import io.avaje.config.Configuration;
import io.avaje.config.load.CoreExpressionEval;
import io.avaje.config.load.LoadContext;
import io.avaje.config.load.YamlLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Loader {
    private static final Logger log = LoggerFactory.getLogger(Loader.class);
    private static final Pattern SPLIT_PATHS = Pattern.compile("[\\s,;]+");
    private final LoadContext loadContext = new LoadContext();
    private YamlLoader yamlLoader;

    public static Configuration.ExpressionEval evalFor(Properties properties) {
        return new CoreExpressionEval(properties);
    }

    public Loader() {
        this.initYamlLoader();
    }

    public Properties load() {
        this.loadEnvironmentVars();
        this.loadLocalFiles();
        return this.eval();
    }

    private void initYamlLoader() {
        if (!"true".equals(System.getProperty("skipYaml"))) {
            try {
                Class<?> exists = Class.forName("org.yaml.snakeyaml.Yaml");
                if (exists != null) {
                    this.yamlLoader = new YamlLoader(this.loadContext);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    void loadEnvironmentVars() {
        this.loadContext.loadEnvironmentVars();
    }

    void loadLocalFiles() {
        this.loadMain(Source.RESOURCE);
        this.loadMain(Source.FILE);
        this.loadViaSystemProperty();
        this.loadViaIndirection();
        if (!this.loadTest()) {
            this.loadLocalDev();
            this.loadViaCommandLineArgs();
        }
    }

    private void loadViaCommandLineArgs() {
        String rawArgs = System.getProperty("sun.java.command");
        if (rawArgs != null) {
            this.loadViaCommandLine(rawArgs.split(" "));
        }
    }

    private void loadViaCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-P") && !arg.startsWith("-p")) continue;
            if (arg.length() == 2 && i < args.length - 1) {
                this.loadViaPaths(args[++i]);
                continue;
            }
            this.loadViaPaths(arg.substring(2));
        }
    }

    private void loadLocalDev() {
        String appName;
        File localDev = new File(System.getProperty("user.home"), ".localdev");
        if (localDev.exists() && (appName = this.loadContext.getAppName()) != null) {
            String prefix = localDev.getAbsolutePath() + File.separator + appName;
            this.loadFileWithExtensionCheck(prefix + ".yaml");
            this.loadFileWithExtensionCheck(prefix + ".properties");
        }
    }

    private boolean loadTest() {
        int before = this.loadContext.size();
        this.loadProperties("application-test.properties", Source.RESOURCE);
        this.loadYaml("application-test.yaml", Source.RESOURCE);
        if (this.loadYaml("application-test.yml", Source.RESOURCE)) {
            log.warn("Please rename application-test.yml to application-test.yaml - Using yml suffix (rather than yaml) is deprecated.");
        }
        if (this.loadProperties("test-ebean.properties", Source.RESOURCE)) {
            log.warn("Loading properties from test-ebean.properties is deprecated. Please migrate to application-test.yaml or application-test.properties instead.");
        }
        return this.loadContext.size() > before;
    }

    private void loadViaIndirection() {
        String paths = this.loadContext.indirectLocation();
        if (paths != null) {
            this.loadViaPaths(paths);
        }
    }

    private void loadViaPaths(String paths) {
        for (String path : this.splitPaths(paths)) {
            this.loadFileWithExtensionCheck(this.loadContext.eval(path));
        }
    }

    String[] splitPaths(String location) {
        return SPLIT_PATHS.split(location);
    }

    private void loadMain(Source source) {
        this.loadYaml("application.yaml", source);
        if (this.loadYaml("application.yml", source)) {
            log.warn("Please rename application.yml to application.yaml - Using yml suffix (rather than yaml) is deprecated.");
        }
        this.loadProperties("application.properties", source);
        if (this.loadProperties("ebean.properties", source)) {
            log.warn("Loading properties from ebean.properties is deprecated. Please migrate to use application.yaml or application.properties instead.");
        }
    }

    private void loadViaSystemProperty() {
        String fileName = System.getenv("PROPS_FILE");
        if (fileName == null && (fileName = System.getProperty("props.file")) != null) {
            this.loadFileWithExtensionCheck(fileName);
        }
    }

    void loadFileWithExtensionCheck(String fileName) {
        if (fileName.endsWith("yaml") || fileName.endsWith("yml")) {
            this.loadYaml(fileName, Source.FILE);
        } else if (fileName.endsWith("properties")) {
            this.loadProperties(fileName, Source.FILE);
        } else {
            throw new IllegalArgumentException("Expecting only yaml or properties file but got [" + fileName + "]");
        }
    }

    Properties eval() {
        return this.loadContext.evalAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean loadYaml(String resourcePath, Source source) {
        if (this.yamlLoader == null) return false;
        try (InputStream is = this.resource(resourcePath, source);){
            if (is == null) return false;
            this.yamlLoader.load(is);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading yaml properties - " + resourcePath, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean loadProperties(String resourcePath, Source source) {
        try (InputStream is = this.resource(resourcePath, source);){
            if (is == null) return false;
            this.loadProperties(is);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties - " + resourcePath, e);
        }
    }

    private InputStream resource(String resourcePath, Source source) {
        return this.loadContext.resource(resourcePath, source);
    }

    private void loadProperties(InputStream is) throws IOException {
        Properties properties = new Properties();
        properties.load(is);
        this.put(properties);
    }

    private void put(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String property = properties.getProperty(key);
            this.loadContext.put(key, property);
        }
    }

    static enum Source {
        RESOURCE,
        FILE;

    }
}

