/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.moduuid;

import java.security.SecureRandom;
import java.util.Base64;
import java.util.UUID;

public class ModUUID {
    private static final SecureRandom shortIdSecureRandom = new SecureRandom();
    private static final Base64.Encoder urlEncoder = Base64.getUrlEncoder();
    private static final long MILLIS_DAY = 86400000L;

    public static String today() {
        return Integer.toHexString((int)(System.currentTimeMillis() / 86400000L));
    }

    public static String newShortId() {
        byte[] randomBytes = new byte[9];
        shortIdSecureRandom.nextBytes(randomBytes);
        return ModUUID.encode64(randomBytes);
    }

    public static String newMediumId() {
        byte[] randomBytes = new byte[12];
        shortIdSecureRandom.nextBytes(randomBytes);
        return ModUUID.encode64(randomBytes);
    }

    public static String newId() {
        return ModUUID.encode(UUID.randomUUID());
    }

    public static String encode(UUID uuid) {
        String val = ModUUID.encode64(ModUUID.asByteArray(uuid));
        return val.substring(0, val.length() - 2);
    }

    private static String encode64(byte[] bytes) {
        return urlEncoder.encodeToString(bytes);
    }

    private static byte[] asByteArray(UUID uuid) {
        int i;
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] buffer = new byte[16];
        for (i = 0; i < 8; ++i) {
            buffer[i] = (byte)(msb >>> 8 * (7 - i));
        }
        for (i = 8; i < 16; ++i) {
            buffer[i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return buffer;
    }
}

