/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="cloud.aws.elasticache")
public class ElastiCacheProperties {
    private List<Cluster> clusters = Collections.emptyList();
    private int defaultExpiration;

    public List<Cluster> getClusters() {
        return this.clusters;
    }

    public void setClusters(List<Cluster> clusters) {
        this.clusters = clusters;
    }

    public int getDefaultExpiration() {
        return this.defaultExpiration;
    }

    public void setDefaultExpiration(int defaultExpiration) {
        this.defaultExpiration = defaultExpiration;
    }

    public List<String> getCacheNames() {
        return this.getClusters().stream().map(Cluster::getName).collect(Collectors.toList());
    }

    public Map<String, Integer> getExpiryTimePerCache() {
        HashMap<String, Integer> expiryTimePerCache = new HashMap<String, Integer>(this.clusters.size());
        for (Cluster cluster : this.clusters) {
            expiryTimePerCache.put(cluster.getName(), cluster.getExpiration());
        }
        return expiryTimePerCache;
    }

    public static class Cluster {
        private String name;
        private int expiration;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getExpiration() {
            return this.expiration;
        }

        public void setExpiration(int expiration) {
            this.expiration = expiration;
        }
    }
}

