/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.messaging;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.AmazonSQSAsyncClient;
import com.amazonaws.services.sqs.buffered.AmazonSQSBufferedAsyncClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.awspring.cloud.autoconfigure.messaging.SqsProperties;
import io.awspring.cloud.context.annotation.ConditionalOnMissingAmazonClient;
import io.awspring.cloud.core.config.AmazonWebserviceClientFactoryBean;
import io.awspring.cloud.core.env.ResourceIdResolver;
import io.awspring.cloud.core.region.RegionProvider;
import io.awspring.cloud.core.region.StaticRegionProvider;
import io.awspring.cloud.messaging.config.QueueMessageHandlerFactory;
import io.awspring.cloud.messaging.config.SimpleMessageListenerContainerFactory;
import io.awspring.cloud.messaging.listener.QueueMessageHandler;
import io.awspring.cloud.messaging.listener.SimpleMessageListenerContainer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.util.CollectionUtils;

@ConditionalOnClass(value={SimpleMessageListenerContainer.class})
@ConditionalOnMissingBean(value={SimpleMessageListenerContainer.class})
@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"cloud.aws.sqs.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={SqsProperties.class})
public class SqsAutoConfiguration {

    @Configuration
    static class SqsConfiguration {
        private final SimpleMessageListenerContainerFactory simpleMessageListenerContainerFactory;
        private final QueueMessageHandlerFactory queueMessageHandlerFactory;
        private final BeanFactory beanFactory;
        private final ResourceIdResolver resourceIdResolver;
        private final MappingJackson2MessageConverter mappingJackson2MessageConverter;
        private final ObjectMapper objectMapper;

        SqsConfiguration(ObjectProvider<SimpleMessageListenerContainerFactory> simpleMessageListenerContainerFactory, ObjectProvider<QueueMessageHandlerFactory> queueMessageHandlerFactory, BeanFactory beanFactory, ObjectProvider<ResourceIdResolver> resourceIdResolver, ObjectProvider<MappingJackson2MessageConverter> mappingJackson2MessageConverter, ObjectProvider<ObjectMapper> objectMapper, SqsProperties sqsProperties) {
            this.simpleMessageListenerContainerFactory = (SimpleMessageListenerContainerFactory)simpleMessageListenerContainerFactory.getIfAvailable(() -> SqsConfiguration.createSimpleMessageListenerContainerFactory(sqsProperties));
            this.queueMessageHandlerFactory = (QueueMessageHandlerFactory)queueMessageHandlerFactory.getIfAvailable(() -> SqsConfiguration.createQueueMessageHandlerFactory(sqsProperties));
            this.beanFactory = beanFactory;
            this.resourceIdResolver = (ResourceIdResolver)resourceIdResolver.getIfAvailable();
            this.mappingJackson2MessageConverter = (MappingJackson2MessageConverter)mappingJackson2MessageConverter.getIfAvailable();
            this.objectMapper = (ObjectMapper)objectMapper.getIfAvailable();
        }

        private static QueueMessageHandlerFactory createQueueMessageHandlerFactory(SqsProperties sqsProperties) {
            QueueMessageHandlerFactory factory = new QueueMessageHandlerFactory();
            Optional.ofNullable(sqsProperties.getHandler().getDefaultDeletionPolicy()).ifPresent(arg_0 -> ((QueueMessageHandlerFactory)factory).setSqsMessageDeletionPolicy(arg_0));
            return factory;
        }

        private static SimpleMessageListenerContainerFactory createSimpleMessageListenerContainerFactory(SqsProperties sqsProperties) {
            SimpleMessageListenerContainerFactory factory = new SimpleMessageListenerContainerFactory();
            Optional.ofNullable(sqsProperties.getListener().getBackOffTime()).ifPresent(arg_0 -> ((SimpleMessageListenerContainerFactory)factory).setBackOffTime(arg_0));
            Optional.ofNullable(sqsProperties.getListener().getMaxNumberOfMessages()).ifPresent(arg_0 -> ((SimpleMessageListenerContainerFactory)factory).setMaxNumberOfMessages(arg_0));
            Optional.ofNullable(sqsProperties.getListener().getQueueStopTimeout()).ifPresent(arg_0 -> ((SimpleMessageListenerContainerFactory)factory).setQueueStopTimeout(arg_0));
            Optional.ofNullable(sqsProperties.getListener().getVisibilityTimeout()).ifPresent(arg_0 -> ((SimpleMessageListenerContainerFactory)factory).setVisibilityTimeout(arg_0));
            Optional.ofNullable(sqsProperties.getListener().getWaitTimeout()).ifPresent(arg_0 -> ((SimpleMessageListenerContainerFactory)factory).setWaitTimeOut(arg_0));
            factory.setAutoStartup(sqsProperties.getListener().isAutoStartup());
            return factory;
        }

        @Bean
        public SimpleMessageListenerContainer simpleMessageListenerContainer(AmazonSQSAsync amazonSqs) {
            if (this.simpleMessageListenerContainerFactory.getAmazonSqs() == null) {
                this.simpleMessageListenerContainerFactory.setAmazonSqs(amazonSqs);
            }
            if (this.simpleMessageListenerContainerFactory.getResourceIdResolver() == null && this.resourceIdResolver != null) {
                this.simpleMessageListenerContainerFactory.setResourceIdResolver(this.resourceIdResolver);
            }
            SimpleMessageListenerContainer simpleMessageListenerContainer = this.simpleMessageListenerContainerFactory.createSimpleMessageListenerContainer();
            simpleMessageListenerContainer.setMessageHandler(this.queueMessageHandler(amazonSqs));
            return simpleMessageListenerContainer;
        }

        @Bean
        public QueueMessageHandler queueMessageHandler(AmazonSQSAsync amazonSqs) {
            if (this.simpleMessageListenerContainerFactory.getQueueMessageHandler() != null) {
                return this.simpleMessageListenerContainerFactory.getQueueMessageHandler();
            }
            return this.getMessageHandler(amazonSqs);
        }

        private QueueMessageHandler getMessageHandler(AmazonSQSAsync amazonSqs) {
            if (this.queueMessageHandlerFactory.getAmazonSqs() == null) {
                this.queueMessageHandlerFactory.setAmazonSqs(amazonSqs);
            }
            if (CollectionUtils.isEmpty((Collection)this.queueMessageHandlerFactory.getMessageConverters()) && this.mappingJackson2MessageConverter != null) {
                this.queueMessageHandlerFactory.setMessageConverters(Arrays.asList(this.mappingJackson2MessageConverter));
            }
            this.queueMessageHandlerFactory.setBeanFactory(this.beanFactory);
            this.queueMessageHandlerFactory.setObjectMapper(this.objectMapper);
            return this.queueMessageHandlerFactory.createQueueMessageHandler();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingAmazonClient(value=AmazonSQS.class)
    static class SqsClientConfiguration {
        private final AWSCredentialsProvider awsCredentialsProvider;
        private final RegionProvider regionProvider;
        private final SqsProperties properties;
        private final ClientConfiguration clientConfiguration;

        SqsClientConfiguration(ObjectProvider<AWSCredentialsProvider> awsCredentialsProvider, ObjectProvider<RegionProvider> regionProvider, SqsProperties properties, @Qualifier(value="com.amazonaws.ClientConfiguration.BEAN_NAME") ObjectProvider<ClientConfiguration> globalClientConfiguration, @Qualifier(value="sqsClientConfiguration") ObjectProvider<ClientConfiguration> sqsClientConfiguration) {
            this.awsCredentialsProvider = (AWSCredentialsProvider)awsCredentialsProvider.getIfAvailable();
            this.regionProvider = properties.getRegion() == null ? (RegionProvider)regionProvider.getIfAvailable() : new StaticRegionProvider(properties.getRegion());
            this.properties = properties;
            this.clientConfiguration = (ClientConfiguration)sqsClientConfiguration.getIfAvailable(() -> globalClientConfiguration.getIfAvailable());
        }

        @Lazy
        @Bean(destroyMethod="shutdown")
        public AmazonSQSBufferedAsyncClient amazonSQS() throws Exception {
            AmazonWebserviceClientFactoryBean clientFactoryBean = new AmazonWebserviceClientFactoryBean(AmazonSQSAsyncClient.class, this.awsCredentialsProvider, this.regionProvider, this.clientConfiguration);
            Optional.ofNullable(this.properties.getEndpoint()).ifPresent(arg_0 -> ((AmazonWebserviceClientFactoryBean)clientFactoryBean).setCustomEndpoint(arg_0));
            clientFactoryBean.afterPropertiesSet();
            return new AmazonSQSBufferedAsyncClient((AmazonSQSAsync)clientFactoryBean.getObject());
        }
    }
}

