/*
 * Copyright 2013-2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.awspring.cloud.autoconfigure.condition;

import io.awspring.cloud.context.support.env.AwsCloudEnvironmentCheckUtils;

import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

/**
 * {@link Condition} that checks if the environment is AWS.
 *
 * @author Agim Emruli
 * @author Gleb Schukin
 * @author Bernardo Martins
 * @author Eddú Meléndez
 */
public class OnAwsCloudEnvironmentCondition extends SpringBootCondition {

	@Override
	public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
		if (AwsCloudEnvironmentCheckUtils.isRunningOnCloudEnvironment()) {
			return ConditionOutcome.match();
		}
		return ConditionOutcome.noMatch("not running in aws environment");
	}

}
