/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.core;

import io.awspring.cloud.autoconfigure.AwsClientProperties;
import io.awspring.cloud.autoconfigure.core.AwsClientCustomizer;
import io.awspring.cloud.autoconfigure.core.AwsProperties;
import io.awspring.cloud.core.SpringCloudClientConfiguration;
import java.util.Optional;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;

public class AwsClientBuilderConfigurer {
    private final AwsCredentialsProvider credentialsProvider;
    private final AwsRegionProvider regionProvider;
    private final AwsProperties awsProperties;
    private final ClientOverrideConfiguration clientOverrideConfiguration;

    AwsClientBuilderConfigurer(AwsCredentialsProvider credentialsProvider, AwsRegionProvider regionProvider, AwsProperties awsProperties) {
        this.credentialsProvider = credentialsProvider;
        this.regionProvider = regionProvider;
        this.awsProperties = awsProperties;
        this.clientOverrideConfiguration = new SpringCloudClientConfiguration().clientOverrideConfiguration();
    }

    public <T extends AwsClientBuilder<?, ?>> T configure(T builder) {
        return this.configure(builder, null, null);
    }

    public <T extends AwsClientBuilder<?, ?>> T configure(T builder, @Nullable AwsClientProperties clientProperties, @Nullable AwsClientCustomizer<T> customizer) {
        Assert.notNull(builder, (String)"builder is required");
        Assert.notNull((Object)clientProperties, (String)"clientProperties are required");
        builder.credentialsProvider(this.credentialsProvider).region(this.resolveRegion(clientProperties)).overrideConfiguration(this.clientOverrideConfiguration);
        Optional.ofNullable(this.awsProperties.getEndpoint()).ifPresent(arg_0 -> builder.endpointOverride(arg_0));
        Optional.ofNullable(clientProperties).map(AwsClientProperties::getEndpoint).ifPresent(arg_0 -> builder.endpointOverride(arg_0));
        Optional.ofNullable(this.awsProperties.getDefaultsMode()).ifPresent(arg_0 -> builder.defaultsMode(arg_0));
        Optional.ofNullable(this.awsProperties.getFipsEnabled()).ifPresent(arg_0 -> builder.fipsEnabled(arg_0));
        Optional.ofNullable(this.awsProperties.getDualstackEnabled()).ifPresent(arg_0 -> builder.dualstackEnabled(arg_0));
        if (customizer != null) {
            AwsClientCustomizer.apply(customizer, builder);
        }
        return builder;
    }

    public Region resolveRegion(@Nullable AwsClientProperties clientProperties) {
        return AwsClientBuilderConfigurer.resolveRegion(clientProperties, this.regionProvider);
    }

    public static Region resolveRegion(@Nullable AwsClientProperties clientProperties, AwsRegionProvider regionProvider) {
        return clientProperties != null && StringUtils.hasLength((String)clientProperties.getRegion()) ? Region.of((String)clientProperties.getRegion()) : regionProvider.getRegion();
    }
}

