/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.sqs;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.awspring.cloud.autoconfigure.core.AwsClientBuilderConfigurer;
import io.awspring.cloud.autoconfigure.core.AwsClientCustomizer;
import io.awspring.cloud.autoconfigure.core.AwsConnectionDetails;
import io.awspring.cloud.autoconfigure.core.CredentialsProviderAutoConfiguration;
import io.awspring.cloud.autoconfigure.core.RegionProviderAutoConfiguration;
import io.awspring.cloud.autoconfigure.sqs.SqsProperties;
import io.awspring.cloud.sqs.config.SqsBootstrapConfiguration;
import io.awspring.cloud.sqs.config.SqsListenerConfigurer;
import io.awspring.cloud.sqs.config.SqsMessageListenerContainerFactory;
import io.awspring.cloud.sqs.listener.ContainerOptionsBuilder;
import io.awspring.cloud.sqs.listener.errorhandler.AsyncErrorHandler;
import io.awspring.cloud.sqs.listener.errorhandler.ErrorHandler;
import io.awspring.cloud.sqs.listener.interceptor.AsyncMessageInterceptor;
import io.awspring.cloud.sqs.listener.interceptor.MessageInterceptor;
import io.awspring.cloud.sqs.operations.SqsTemplate;
import io.awspring.cloud.sqs.operations.SqsTemplateBuilder;
import io.awspring.cloud.sqs.support.converter.MessagingMessageConverter;
import io.awspring.cloud.sqs.support.converter.SqsMessagingMessageConverter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsAsyncClientBuilder;

@AutoConfiguration
@ConditionalOnClass(value={SqsAsyncClient.class, SqsBootstrapConfiguration.class})
@EnableConfigurationProperties(value={SqsProperties.class})
@Import(value={SqsBootstrapConfiguration.class})
@AutoConfigureAfter(value={CredentialsProviderAutoConfiguration.class, RegionProviderAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.cloud.aws.sqs.enabled"}, havingValue="true", matchIfMissing=true)
public class SqsAutoConfiguration {
    private final SqsProperties sqsProperties;

    public SqsAutoConfiguration(SqsProperties sqsProperties) {
        this.sqsProperties = sqsProperties;
    }

    @ConditionalOnMissingBean
    @Bean
    public SqsAsyncClient sqsAsyncClient(AwsClientBuilderConfigurer awsClientBuilderConfigurer, ObjectProvider<AwsClientCustomizer<SqsAsyncClientBuilder>> configurer, ObjectProvider<AwsConnectionDetails> connectionDetails) {
        return (SqsAsyncClient)awsClientBuilderConfigurer.configure(SqsAsyncClient.builder(), this.sqsProperties, (AwsConnectionDetails)connectionDetails.getIfAvailable(), (AwsClientCustomizer)configurer.getIfAvailable()).build();
    }

    @ConditionalOnMissingBean
    @Bean
    public SqsTemplate sqsTemplate(SqsAsyncClient sqsAsyncClient, ObjectProvider<ObjectMapper> objectMapperProvider) {
        SqsTemplateBuilder builder = SqsTemplate.builder().sqsAsyncClient(sqsAsyncClient);
        objectMapperProvider.ifAvailable(om -> builder.configureDefaultConverter(converter -> converter.setObjectMapper(om)));
        return builder.build();
    }

    @ConditionalOnMissingBean
    @Bean
    public SqsMessageListenerContainerFactory<Object> defaultSqsListenerContainerFactory(ObjectProvider<SqsAsyncClient> sqsAsyncClient, ObjectProvider<AsyncErrorHandler<Object>> asyncErrorHandler, ObjectProvider<ErrorHandler<Object>> errorHandler, ObjectProvider<AsyncMessageInterceptor<Object>> asyncInterceptors, ObjectProvider<MessageInterceptor<Object>> interceptors, ObjectProvider<ObjectMapper> objectMapperProvider) {
        SqsMessageListenerContainerFactory factory = new SqsMessageListenerContainerFactory();
        factory.configure(this::configureContainerOptions);
        sqsAsyncClient.ifAvailable(arg_0 -> ((SqsMessageListenerContainerFactory)factory).setSqsAsyncClient(arg_0));
        asyncErrorHandler.ifAvailable(arg_0 -> ((SqsMessageListenerContainerFactory)factory).setErrorHandler(arg_0));
        errorHandler.ifAvailable(arg_0 -> ((SqsMessageListenerContainerFactory)factory).setErrorHandler(arg_0));
        interceptors.forEach(arg_0 -> ((SqsMessageListenerContainerFactory)factory).addMessageInterceptor(arg_0));
        asyncInterceptors.forEach(arg_0 -> ((SqsMessageListenerContainerFactory)factory).addMessageInterceptor(arg_0));
        objectMapperProvider.ifAvailable(objectMapper -> this.setObjectMapper((SqsMessageListenerContainerFactory<Object>)factory, (ObjectMapper)objectMapper));
        return factory;
    }

    private void setObjectMapper(SqsMessageListenerContainerFactory<Object> factory, ObjectMapper objectMapper) {
        SqsMessagingMessageConverter messageConverter = new SqsMessagingMessageConverter();
        messageConverter.setObjectMapper(objectMapper);
        factory.configure(options -> options.messageConverter((MessagingMessageConverter)messageConverter));
    }

    private void configureContainerOptions(ContainerOptionsBuilder<?, ?> options) {
        PropertyMapper mapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        mapper.from((Object)this.sqsProperties.getListener().getMaxConcurrentMessages()).to(arg_0 -> options.maxConcurrentMessages(arg_0));
        mapper.from((Object)this.sqsProperties.getListener().getMaxMessagesPerPoll()).to(arg_0 -> options.maxMessagesPerPoll(arg_0));
        mapper.from((Object)this.sqsProperties.getListener().getPollTimeout()).to(arg_0 -> options.pollTimeout(arg_0));
    }

    @Bean
    public SqsListenerConfigurer objectMapperCustomizer(ObjectProvider<ObjectMapper> objectMapperProvider) {
        ObjectMapper objectMapper = (ObjectMapper)objectMapperProvider.getIfUnique();
        return registrar -> {
            if (registrar.getObjectMapper() == null && objectMapper != null) {
                registrar.setObjectMapper(objectMapper);
            }
        };
    }
}

