/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.ses;

import io.awspring.cloud.autoconfigure.AwsSyncClientCustomizer;
import io.awspring.cloud.autoconfigure.core.AwsClientBuilderConfigurer;
import io.awspring.cloud.autoconfigure.core.AwsConnectionDetails;
import io.awspring.cloud.autoconfigure.core.CredentialsProviderAutoConfiguration;
import io.awspring.cloud.autoconfigure.core.RegionProviderAutoConfiguration;
import io.awspring.cloud.autoconfigure.ses.SesClientCustomizer;
import io.awspring.cloud.autoconfigure.ses.SesProperties;
import io.awspring.cloud.ses.SimpleEmailServiceJavaMailSender;
import io.awspring.cloud.ses.SimpleEmailServiceMailSender;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.mail.MailSender;
import org.springframework.mail.javamail.JavaMailSender;
import software.amazon.awssdk.services.ses.SesClient;

@AutoConfiguration
@EnableConfigurationProperties(value={SesProperties.class})
@ConditionalOnClass(value={SesClient.class, MailSender.class, SimpleEmailServiceJavaMailSender.class})
@AutoConfigureAfter(value={CredentialsProviderAutoConfiguration.class, RegionProviderAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.cloud.aws.ses.enabled"}, havingValue="true", matchIfMissing=true)
public class SesAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SesClient sesClient(SesProperties properties, AwsClientBuilderConfigurer awsClientBuilderConfigurer, ObjectProvider<AwsConnectionDetails> connectionDetails, ObjectProvider<SesClientCustomizer> sesClientCustomizers, ObjectProvider<AwsSyncClientCustomizer> awsSyncClientCustomizers) {
        return (SesClient)awsClientBuilderConfigurer.configureSyncClient(SesClient.builder(), properties, (AwsConnectionDetails)connectionDetails.getIfAvailable(), sesClientCustomizers.orderedStream(), awsSyncClientCustomizers.orderedStream()).build();
    }

    @Bean
    @ConditionalOnMissingClass(value={"jakarta.mail.Session"})
    public MailSender simpleMailSender(SesClient sesClient, SesProperties properties) {
        return new SimpleEmailServiceMailSender(sesClient, properties.getSourceArn(), properties.getConfigurationSetName());
    }

    @Bean
    @ConditionalOnClass(name={"jakarta.mail.Session"})
    public JavaMailSender javaMailSender(SesClient sesClient, SesProperties properties) {
        return new SimpleEmailServiceJavaMailSender(sesClient, properties.getSourceArn(), properties.getConfigurationSetName());
    }
}

