/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.cache.config.annotation;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.elasticache.AmazonElastiCache;
import com.amazonaws.services.elasticache.AmazonElastiCacheClient;
import io.awspring.cloud.cache.CacheFactory;
import io.awspring.cloud.cache.config.annotation.ElastiCacheCacheConfigurer;
import io.awspring.cloud.cache.config.annotation.EnableElastiCache;
import io.awspring.cloud.cache.memcached.MemcachedCacheFactory;
import io.awspring.cloud.cache.redis.RedisCacheFactory;
import io.awspring.cloud.context.annotation.ConditionalOnClass;
import io.awspring.cloud.context.annotation.ConditionalOnMissingAmazonClient;
import io.awspring.cloud.context.config.annotation.ContextDefaultConfigurationRegistrar;
import io.awspring.cloud.core.config.AmazonWebserviceClientFactoryBean;
import io.awspring.cloud.core.env.ResourceIdResolver;
import io.awspring.cloud.core.env.stack.ListableStackResourceFactory;
import io.awspring.cloud.core.env.stack.StackResource;
import io.awspring.cloud.core.region.RegionProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cache.annotation.CachingConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@Import(value={ContextDefaultConfigurationRegistrar.class})
@Deprecated
public class ElastiCacheCachingConfiguration
implements ImportAware {
    private static final String CACHE_CLUSTER_CONFIG_ATTRIBUTE_NAME = "value";
    private static final String DEFAULT_EXPIRY_TIME_ATTRIBUTE_NAME = "defaultExpiration";
    private AnnotationAttributes annotationAttributes;
    private final RegionProvider regionProvider;
    private final AWSCredentialsProvider credentialsProvider;
    private final ListableStackResourceFactory stackResourceFactory;

    public ElastiCacheCachingConfiguration(ObjectProvider<RegionProvider> regionProvider, ObjectProvider<AWSCredentialsProvider> credentialsProvider, ObjectProvider<ListableStackResourceFactory> stackResourceFactory) {
        this.regionProvider = (RegionProvider)regionProvider.getIfAvailable();
        this.credentialsProvider = (AWSCredentialsProvider)credentialsProvider.getIfAvailable();
        this.stackResourceFactory = (ListableStackResourceFactory)stackResourceFactory.getIfAvailable();
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.annotationAttributes = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableElastiCache.class.getName(), false));
        Assert.notNull((Object)this.annotationAttributes, (String)("@EnableElasticache is not present on importing class " + importMetadata.getClassName()));
    }

    @Bean
    @ConditionalOnMissingAmazonClient(value=AmazonElastiCache.class)
    public AmazonWebserviceClientFactoryBean<AmazonElastiCacheClient> amazonElastiCache() {
        return new AmazonWebserviceClientFactoryBean(AmazonElastiCacheClient.class, this.credentialsProvider, this.regionProvider);
    }

    @Bean
    public CachingConfigurer cachingConfigurer(AmazonElastiCache amazonElastiCache, ResourceIdResolver resourceIdResolver, List<CacheFactory> cacheFactories) {
        if (this.annotationAttributes != null && this.annotationAttributes.getAnnotationArray(CACHE_CLUSTER_CONFIG_ATTRIBUTE_NAME).length > 0) {
            return new ElastiCacheCacheConfigurer(amazonElastiCache, resourceIdResolver, this.getCacheNamesFromCacheClusterConfigs(this.annotationAttributes.getAnnotationArray(CACHE_CLUSTER_CONFIG_ATTRIBUTE_NAME)), cacheFactories);
        }
        return new ElastiCacheCacheConfigurer(amazonElastiCache, resourceIdResolver, this.getConfiguredCachesInStack(), cacheFactories);
    }

    @Bean
    @ConditionalOnClass(value="org.springframework.data.redis.connection.RedisConnectionFactory")
    public RedisCacheFactory redisCacheFactory() {
        RedisCacheFactory redisCacheFactory = new RedisCacheFactory();
        redisCacheFactory.setExpiryTimePerCache(this.getExpiryTimePerCacheFromAnnotationConfig(this.annotationAttributes.getAnnotationArray(CACHE_CLUSTER_CONFIG_ATTRIBUTE_NAME)));
        redisCacheFactory.setExpiryTime((Integer)this.annotationAttributes.getNumber(DEFAULT_EXPIRY_TIME_ATTRIBUTE_NAME));
        return redisCacheFactory;
    }

    @Bean
    @ConditionalOnClass(value="net.spy.memcached.MemcachedClient")
    public MemcachedCacheFactory memcachedCacheFactory() {
        MemcachedCacheFactory redisCacheFactory = new MemcachedCacheFactory();
        redisCacheFactory.setExpiryTimePerCache(this.getExpiryTimePerCacheFromAnnotationConfig(this.annotationAttributes.getAnnotationArray(CACHE_CLUSTER_CONFIG_ATTRIBUTE_NAME)));
        redisCacheFactory.setExpiryTime((Integer)this.annotationAttributes.getNumber(DEFAULT_EXPIRY_TIME_ATTRIBUTE_NAME));
        return redisCacheFactory;
    }

    private List<String> getCacheNamesFromCacheClusterConfigs(AnnotationAttributes[] annotationAttributes) {
        ArrayList<String> cacheNames = new ArrayList<String>(annotationAttributes.length);
        for (AnnotationAttributes annotationAttribute : annotationAttributes) {
            cacheNames.add(annotationAttribute.getString("name"));
        }
        return cacheNames;
    }

    private Map<String, Integer> getExpiryTimePerCacheFromAnnotationConfig(AnnotationAttributes[] annotationAttributes) {
        HashMap<String, Integer> expiryTimePerCache = new HashMap<String, Integer>(annotationAttributes.length);
        for (AnnotationAttributes annotationAttribute : annotationAttributes) {
            expiryTimePerCache.put(annotationAttribute.getString("name"), (Integer)annotationAttribute.getNumber("expiration"));
        }
        return expiryTimePerCache;
    }

    private List<String> getConfiguredCachesInStack() {
        ArrayList<String> cacheNames = new ArrayList<String>();
        if (this.stackResourceFactory != null) {
            for (StackResource stackResource : this.stackResourceFactory.resourcesByType("AWS::ElastiCache::CacheCluster")) {
                cacheNames.add(stackResource.getLogicalId());
            }
        }
        return cacheNames;
    }
}

