/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.cache;

import io.awspring.cloud.cache.CacheFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractCacheFactory<T>
implements CacheFactory,
DisposableBean {
    private final Map<String, T> nativeConnectionClients = new HashMap<String, T>();
    private final Map<String, Integer> expiryTimePerCache = new HashMap<String, Integer>();
    private int expiryTime;

    protected AbstractCacheFactory() {
    }

    protected AbstractCacheFactory(Map<String, Integer> expiryTimePerCache, int expiryTime) {
        this.setExpiryTimePerCache(expiryTimePerCache);
        this.setExpiryTime(expiryTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        Map<String, T> map = this.nativeConnectionClients;
        synchronized (map) {
            for (T connectionClient : this.nativeConnectionClients.values()) {
                this.destroyConnectionClient(connectionClient);
            }
        }
    }

    protected abstract void destroyConnectionClient(T var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final T getConnectionFactory(String hostName, int port) throws Exception {
        Map<String, T> map = this.nativeConnectionClients;
        synchronized (map) {
            if (!this.nativeConnectionClients.containsKey(hostName)) {
                T nativeConnectionClient = this.createConnectionClient(hostName, port);
                if (nativeConnectionClient instanceof InitializingBean) {
                    ((InitializingBean)nativeConnectionClient).afterPropertiesSet();
                }
                this.nativeConnectionClients.put(hostName, nativeConnectionClient);
            }
            return this.nativeConnectionClients.get(hostName);
        }
    }

    protected abstract T createConnectionClient(String var1, int var2) throws IOException;

    protected int getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(int expiryTime) {
        this.expiryTime = expiryTime;
    }

    public void setExpiryTimePerCache(Map<String, Integer> expiryTimePerCache) {
        this.expiryTimePerCache.putAll(expiryTimePerCache);
    }

    protected int getExpiryTime(String cacheName) {
        if (this.expiryTimePerCache.containsKey(cacheName) && this.expiryTimePerCache.get(cacheName) != null && this.expiryTimePerCache.get(cacheName) != 0) {
            return this.expiryTimePerCache.get(cacheName);
        }
        return this.getExpiryTime();
    }
}

