/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.cache.memcached;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import net.spy.memcached.MemcachedClientIF;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.util.Assert;

public class SimpleSpringMemcached
implements Cache {
    private final MemcachedClientIF memcachedClientIF;
    private final String cacheName;
    private int expiration;

    public SimpleSpringMemcached(MemcachedClientIF memcachedClientIF, String cacheName) {
        Assert.notNull((Object)memcachedClientIF, (String)"memcachedClient is mandatory");
        Assert.notNull((Object)cacheName, (String)"cacheName is mandatory");
        this.memcachedClientIF = memcachedClientIF;
        this.cacheName = cacheName;
    }

    public String getName() {
        return this.cacheName;
    }

    public Object getNativeCache() {
        return this.memcachedClientIF;
    }

    public Cache.ValueWrapper get(Object key) {
        Assert.notNull((Object)key, (String)"key parameter is mandatory");
        Assert.isAssignable(String.class, key.getClass());
        Object result = this.memcachedClientIF.get((String)key);
        return result != null ? new SimpleValueWrapper(result) : null;
    }

    public <T> T get(Object key, Class<T> type) {
        Assert.notNull((Object)key, (String)"key parameter is mandatory");
        Assert.isAssignable(String.class, key.getClass());
        Object result = this.memcachedClientIF.get((String)key);
        if (result == null) {
            return null;
        }
        Assert.isAssignable(type, result.getClass());
        return type.cast(result);
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        T newValue;
        Cache.ValueWrapper valueWrapper = this.get(key);
        if (valueWrapper != null) {
            return (T)valueWrapper.get();
        }
        try {
            newValue = valueLoader.call();
        }
        catch (Throwable ex) {
            throw new Cache.ValueRetrievalException(key, valueLoader, ex);
        }
        this.put(key, newValue);
        return newValue;
    }

    public void put(Object key, Object value) {
        Assert.notNull((Object)key, (String)"key parameter is mandatory");
        Assert.isAssignable(String.class, key.getClass());
        try {
            this.memcachedClientIF.set((String)key, this.expiration, value).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException("Error writing key" + key, e);
        }
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Assert.notNull((Object)key, (String)"key parameter is mandatory");
        Assert.isAssignable(String.class, key.getClass());
        Cache.ValueWrapper valueWrapper = this.get(key);
        if (valueWrapper == null) {
            try {
                this.memcachedClientIF.add((String)key, this.expiration, value).get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new IllegalArgumentException("Error writing key" + key, e);
            }
            return null;
        }
        return valueWrapper;
    }

    public void evict(Object key) {
        Assert.notNull((Object)key, (String)"key parameter is mandatory");
        Assert.isAssignable(String.class, key.getClass());
        try {
            this.memcachedClientIF.delete((String)key).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException("Error evicting items" + key);
        }
    }

    public void clear() {
        this.memcachedClientIF.flush();
    }

    public void setExpiration(int expiration) {
        this.expiration = expiration;
    }
}

