/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.dynamodb;

import io.awspring.cloud.dynamodb.DynamoDbTableNameResolver;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class DefaultDynamoDbTableNameResolver
implements DynamoDbTableNameResolver {
    private final Map<Class<?>, String> tableNameCache = new ConcurrentHashMap();
    private final String tablePrefix;
    private final String tableSuffix;
    private final String tableSeparator;

    public DefaultDynamoDbTableNameResolver() {
        this(null, null, null);
    }

    public DefaultDynamoDbTableNameResolver(@Nullable String tablePrefix) {
        this(tablePrefix, null, null);
    }

    public DefaultDynamoDbTableNameResolver(@Nullable String tablePrefix, @Nullable String tableSuffix) {
        this(tablePrefix, tableSuffix, null);
    }

    public DefaultDynamoDbTableNameResolver(@Nullable String tablePrefix, @Nullable String tableSuffix, @Nullable String tableSeparator) {
        this.tablePrefix = StringUtils.hasText((String)tablePrefix) ? tablePrefix : "";
        this.tableSuffix = StringUtils.hasText((String)tableSuffix) ? tableSuffix : "";
        this.tableSeparator = StringUtils.hasText((String)tableSeparator) ? tableSeparator : "_";
    }

    @Override
    public <T> String resolve(Class<T> clazz) {
        return this.tableNameCache.computeIfAbsent(clazz, this::resolveInternal);
    }

    private <T> String resolveInternal(Class<T> clazz) {
        String className = clazz.getSimpleName().replaceAll("(.)(\\p{Lu})", "$1" + this.tableSeparator + "$2");
        return this.tablePrefix + className.toLowerCase(Locale.ROOT) + this.tableSuffix;
    }

    Map<Class<?>, String> getTableNameCache() {
        return this.tableNameCache;
    }
}

