/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.jdbc.datasource;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class ReadOnlyRoutingDataSource
extends AbstractRoutingDataSource {
    private final List<Object> dataSources = new ArrayList<Object>();
    private List<Object> dataSourceKeys;

    private static int getRandom(int high) {
        return (int)(Math.random() * (double)high);
    }

    public void setTargetDataSources(Map<Object, Object> targetDataSources) {
        super.setTargetDataSources(targetDataSources);
        this.dataSourceKeys = new ArrayList<Object>(targetDataSources.keySet());
        this.dataSources.addAll(targetDataSources.values());
    }

    public void setDefaultTargetDataSource(Object defaultTargetDataSource) {
        super.setDefaultTargetDataSource(defaultTargetDataSource);
        this.dataSources.add(defaultTargetDataSource);
    }

    protected Object determineCurrentLookupKey() {
        if (TransactionSynchronizationManager.isCurrentTransactionReadOnly() && !this.dataSourceKeys.isEmpty()) {
            return this.dataSourceKeys.get(ReadOnlyRoutingDataSource.getRandom(this.dataSourceKeys.size()));
        }
        return null;
    }

    public List<Object> getDataSources() {
        return this.dataSources;
    }
}

