/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.jdbc.rds;

import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.model.DBInstance;
import io.awspring.cloud.jdbc.datasource.ReadOnlyRoutingDataSource;
import io.awspring.cloud.jdbc.rds.AmazonRdsDataSourceFactoryBean;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.LazyConnectionDataSourceProxy;

public class AmazonRdsReadReplicaAwareDataSourceFactoryBean
extends AmazonRdsDataSourceFactoryBean {
    public AmazonRdsReadReplicaAwareDataSourceFactoryBean(AmazonRDS amazonRDS, String dbInstanceIdentifier, String password) {
        super(amazonRDS, dbInstanceIdentifier, password);
    }

    @Override
    protected DataSource createInstance() throws Exception {
        DBInstance dbInstance = this.getDbInstance(this.getDbInstanceIdentifier());
        if (dbInstance.getReadReplicaDBInstanceIdentifiers().isEmpty()) {
            return super.createInstance();
        }
        HashMap<Object, Object> replicaMap = new HashMap<Object, Object>(dbInstance.getReadReplicaDBInstanceIdentifiers().size());
        for (String replicaName : dbInstance.getReadReplicaDBInstanceIdentifiers()) {
            replicaMap.put(replicaName, this.createDataSourceInstance(replicaName));
        }
        ReadOnlyRoutingDataSource dataSource = new ReadOnlyRoutingDataSource();
        dataSource.setTargetDataSources(replicaMap);
        dataSource.setDefaultTargetDataSource(this.createDataSourceInstance(this.getDbInstanceIdentifier()));
        dataSource.afterPropertiesSet();
        return new LazyConnectionDataSourceProxy((DataSource)((Object)dataSource));
    }

    @Override
    protected void destroyInstance(DataSource instance) throws Exception {
        DataSource targetDataSource;
        if (instance instanceof LazyConnectionDataSourceProxy && (targetDataSource = ((LazyConnectionDataSourceProxy)instance).getTargetDataSource()) instanceof ReadOnlyRoutingDataSource) {
            List<Object> dataSources = ((ReadOnlyRoutingDataSource)((Object)targetDataSource)).getDataSources();
            for (Object candidate : dataSources) {
                if (!(candidate instanceof DataSource)) continue;
                super.destroyInstance(instance);
            }
        }
    }
}

