/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.paramstore;

import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.model.GetParametersByPathRequest;
import com.amazonaws.services.simplesystemsmanagement.model.GetParametersByPathResult;
import com.amazonaws.services.simplesystemsmanagement.model.Parameter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.EnumerablePropertySource;

public class AwsParamStorePropertySource
extends EnumerablePropertySource<AWSSimpleSystemsManagement> {
    private static Log LOG = LogFactory.getLog(AwsParamStorePropertySource.class);
    private final String context;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public AwsParamStorePropertySource(String context, AWSSimpleSystemsManagement ssmClient) {
        super(context, (Object)ssmClient);
        this.context = context;
    }

    public void init() {
        GetParametersByPathRequest paramsRequest = new GetParametersByPathRequest().withPath(this.context).withRecursive(Boolean.valueOf(true)).withWithDecryption(Boolean.valueOf(true));
        this.getParameters(paramsRequest);
    }

    public String[] getPropertyNames() {
        return (String[])this.properties.keySet().stream().toArray(String[]::new);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    private void getParameters(GetParametersByPathRequest paramsRequest) {
        GetParametersByPathResult paramsResult = ((AWSSimpleSystemsManagement)this.source).getParametersByPath(paramsRequest);
        for (Parameter parameter : paramsResult.getParameters()) {
            String key = parameter.getName().replace(this.context, "").replace('/', '.').replaceAll("_(\\d)_", "[$1]");
            LOG.debug((Object)("Populating property retrieved from AWS Parameter Store: " + key));
            this.properties.put(key, parameter.getValue());
        }
        if (paramsResult.getNextToken() != null) {
            this.getParameters(paramsRequest.withNextToken(paramsResult.getNextToken()));
        }
    }
}

