/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3.crossregion;

import io.awspring.cloud.s3.crossregion.AbstractCrossRegionS3Client;
import io.awspring.cloud.s3.crossregion.ConcurrentLruMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public class CrossRegionS3Client
extends AbstractCrossRegionS3Client {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"io.awspring.cloud.s3.CrossRegionS3Client");
    private static final int DEFAULT_BUCKET_CACHE_SIZE = 20;
    public static final String BUCKET_REDIRECT_HEADER = "x-amz-bucket-region";
    private static final int HTTP_CODE_PERMANENT_REDIRECT = 301;
    private final Map<Region, S3Client> clientCache = new ConcurrentHashMap<Region, S3Client>(Region.regions().size());
    private final S3Client defaultS3Client;
    private final S3ClientBuilder clientBuilder;
    private final ConcurrentLruMap<String, S3Client> bucketCache;

    public CrossRegionS3Client(S3ClientBuilder clientBuilder) {
        this(20, clientBuilder);
    }

    public CrossRegionS3Client(int bucketCacheSize, S3ClientBuilder clientBuilder) {
        this.defaultS3Client = (S3Client)clientBuilder.build();
        this.clientBuilder = clientBuilder;
        this.bucketCache = new ConcurrentLruMap(bucketCacheSize);
    }

    Map<Region, S3Client> getClientCache() {
        return this.clientCache;
    }

    protected S3Client getClient(Region region) {
        return this.clientCache.computeIfAbsent(region, r -> {
            LOGGER.debug("Creating new S3 client for region: {}", r);
            return (S3Client)((S3ClientBuilder)this.clientBuilder.region(r)).build();
        });
    }

    @Override
    <R> R executeInDefaultRegion(Function<S3Client, R> fn) {
        return fn.apply(this.defaultS3Client);
    }

    @Override
    <R> R executeInBucketRegion(String bucket, Function<S3Client, R> fn) {
        return this.executeInBucketRegion(bucket, fn, true);
    }

    <R> R executeInBucketRegion(String bucket, Function<S3Client, R> fn, boolean allowRecursiveRegionSearch) {
        try {
            if (!this.bucketCache.contains(bucket)) {
                return fn.apply(this.defaultS3Client);
            }
        }
        catch (S3Exception e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Exception when requesting S3: {}", (Object)e.awsErrorDetails().errorCode(), (Object)e);
            } else {
                LOGGER.debug("Exception when requesting S3 for bucket: {}: details=[{}, {}], httpcode={}", new Object[]{bucket, e.awsErrorDetails().errorCode(), e.awsErrorDetails().errorMessage(), e.awsErrorDetails().sdkHttpResponse().statusCode()});
            }
            if (e.awsErrorDetails().sdkHttpResponse().statusCode() != 301) {
                throw e;
            }
            Optional<Region> discoveredRegion = e.awsErrorDetails().sdkHttpResponse().firstMatchingHeader(BUCKET_REDIRECT_HEADER).map(Region::of);
            if (discoveredRegion.isPresent()) {
                LOGGER.debug("Region for bucket was discovered to be {} and is being cached", (Object)discoveredRegion.get());
                this.bucketCache.put(bucket, this.getClient(discoveredRegion.get()));
            }
            if (allowRecursiveRegionSearch) {
                LOGGER.debug("The error headers did not contain the bucket region header, attempting to find the bucket via a HeadBucket request");
                this.executeInBucketRegion(bucket, c -> c.headBucket(b -> b.bucket(bucket)), false);
            }
            throw RegionDiscoveryException.ofMissingHeader(e);
        }
        return fn.apply(this.bucketCache.get(bucket));
    }

    public void close() {
        this.clientCache.values().forEach(SdkAutoCloseable::close);
    }

    @Override
    public HeadBucketResponse headBucket(HeadBucketRequest request) throws AwsServiceException, SdkClientException {
        return this.executeInBucketRegion(request.bucket(), c -> c.headBucket(request), false);
    }

    @Override
    public ListObjectsResponse listObjects(ListObjectsRequest request) throws AwsServiceException, SdkClientException {
        return this.executeInBucketRegion(request.bucket(), c -> c.listObjects(request), false);
    }

    public static class RegionDiscoveryException
    extends RuntimeException {
        private static final String HEADER_ERROR_TEMPLATE = "Not able to find the '%s' header in the S3Exception http details (%s)";

        public RegionDiscoveryException(String message, S3Exception e) {
            super(message, (Throwable)e);
        }

        public static RegionDiscoveryException ofMissingHeader(S3Exception e) {
            return new RegionDiscoveryException(String.format(HEADER_ERROR_TEMPLATE, CrossRegionS3Client.BUCKET_REDIRECT_HEADER, e.awsErrorDetails().sdkHttpResponse().headers()), e);
        }
    }
}

