/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.secretsmanager;

import java.net.URI;
import java.util.regex.Pattern;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@ConfigurationProperties(prefix="aws.secretsmanager")
public class AwsSecretsManagerProperties
implements Validator {
    public static final String CONFIG_PREFIX = "aws.secretsmanager";
    private static final Pattern PREFIX_PATTERN = Pattern.compile("(/)?([a-zA-Z0-9.\\-_]+)*");
    private static final Pattern PROFILE_SEPARATOR_PATTERN = Pattern.compile("[a-zA-Z0-9.\\-_/\\\\]+");
    private String prefix = "/secret";
    private String defaultContext = "application";
    private String profileSeparator = "_";
    private boolean failFast = true;
    private String region;
    private URI endpoint;
    private String name;
    private boolean enabled = true;

    public boolean supports(Class<?> clazz) {
        return AwsSecretsManagerProperties.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        AwsSecretsManagerProperties properties = (AwsSecretsManagerProperties)target;
        if (!StringUtils.hasLength((String)properties.getPrefix())) {
            errors.rejectValue("prefix", "NotEmpty", "prefix should not be empty or null.");
        }
        if (!StringUtils.hasLength((String)properties.getDefaultContext())) {
            errors.rejectValue("defaultContext", "NotEmpty", "defaultContext should not be empty or null.");
        }
        if (!StringUtils.hasLength((String)properties.getProfileSeparator())) {
            errors.rejectValue("profileSeparator", "NotEmpty", "profileSeparator should not be empty or null.");
        }
        if (!PREFIX_PATTERN.matcher(properties.getPrefix()).matches()) {
            errors.rejectValue("prefix", "Pattern", "The prefix must have pattern of:  " + PREFIX_PATTERN.toString());
        }
        if (!PROFILE_SEPARATOR_PATTERN.matcher(properties.getProfileSeparator()).matches()) {
            errors.rejectValue("profileSeparator", "Pattern", "The profileSeparator must have pattern of:  " + PROFILE_SEPARATOR_PATTERN.toString());
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getDefaultContext() {
        return this.defaultContext;
    }

    public void setDefaultContext(String defaultContext) {
        this.defaultContext = defaultContext;
    }

    public String getProfileSeparator() {
        return this.profileSeparator;
    }

    public void setProfileSeparator(String profileSeparator) {
        this.profileSeparator = profileSeparator;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }
}

