/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sns.core;

import io.awspring.cloud.sns.core.TopicArnResolver;
import io.awspring.cloud.sns.core.TopicNotFoundException;
import java.util.Optional;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.ListTopicsRequest;
import software.amazon.awssdk.services.sns.model.ListTopicsResponse;
import software.amazon.awssdk.services.sns.model.Topic;

public class TopicsListingTopicArnResolver
implements TopicArnResolver {
    private final SnsClient snsClient;

    public TopicsListingTopicArnResolver(SnsClient snsClient) {
        Assert.notNull((Object)snsClient, (String)"SnsClient cannot be null!");
        this.snsClient = snsClient;
    }

    @Override
    public Arn resolveTopicArn(String topicName) {
        Assert.notNull((Object)topicName, (String)"topicName must not be null");
        if (topicName.toLowerCase().startsWith("arn:")) {
            return Arn.fromString((String)topicName);
        }
        return this.resolveTopicArnBySnsCall(topicName);
    }

    private Arn resolveTopicArnBySnsCall(String topicName) {
        ListTopicsResponse listTopicsResponse = this.snsClient.listTopics();
        return this.checkIfArnIsInList(topicName, listTopicsResponse);
    }

    private Arn doRecursiveCall(@Nullable String token, String topicName) {
        if (token != null) {
            ListTopicsResponse topicsResponse = this.snsClient.listTopics((ListTopicsRequest)ListTopicsRequest.builder().nextToken(token).build());
            return this.checkIfArnIsInList(topicName, topicsResponse);
        }
        throw new TopicNotFoundException("Topic does not exist for given topic name!");
    }

    private Arn checkIfArnIsInList(String topicName, ListTopicsResponse listTopicsResponse) {
        Optional<String> arn = listTopicsResponse.topics().stream().map(Topic::topicArn).filter(ta -> ta.endsWith(":" + topicName)).findFirst();
        if (arn.isPresent()) {
            return Arn.fromString((String)arn.get());
        }
        return this.doRecursiveCall(listTopicsResponse.nextToken(), topicName);
    }
}

