/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sns.integration;

import com.fasterxml.jackson.databind.JsonNode;
import io.awspring.cloud.sns.handlers.NotificationStatus;
import io.awspring.cloud.sns.handlers.NotificationStatusHandlerMethodArgumentResolver;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.http.inbound.HttpRequestHandlingMessagingGateway;
import org.springframework.integration.http.inbound.RequestMapping;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartResolver;
import software.amazon.awssdk.services.sns.SnsClient;

public class SnsInboundChannelAdapter
extends HttpRequestHandlingMessagingGateway {
    private final NotificationStatusResolver notificationStatusResolver;
    private final MappingJackson2HttpMessageConverter jackson2HttpMessageConverter = new MappingJackson2HttpMessageConverter();
    private final String[] path;
    private volatile boolean handleNotificationStatus;
    private volatile Expression payloadExpression;
    private EvaluationContext evaluationContext;

    public SnsInboundChannelAdapter(SnsClient amazonSns, String ... path) {
        super(false);
        Assert.notNull((Object)amazonSns, (String)"'amazonSns' must not be null.");
        Assert.notNull((Object)path, (String)"'path' must not be null.");
        Assert.noNullElements((Object[])path, (String)"'path' must not contain null elements.");
        this.path = path;
        this.notificationStatusResolver = new NotificationStatusResolver(amazonSns);
        this.jackson2HttpMessageConverter.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON, MediaType.TEXT_PLAIN));
    }

    public void setHandleNotificationStatus(boolean handleNotificationStatus) {
        this.handleNotificationStatus = handleNotificationStatus;
    }

    protected void onInit() {
        super.onInit();
        RequestMapping requestMapping = new RequestMapping();
        requestMapping.setMethods(new HttpMethod[]{HttpMethod.POST});
        requestMapping.setHeaders(new String[]{"x-amz-sns-message-type"});
        requestMapping.setPathPatterns(this.path);
        super.setStatusCodeExpression((Expression)new ValueExpression((Object)HttpStatus.NO_CONTENT));
        super.setMessageConverters(Collections.singletonList(this.jackson2HttpMessageConverter));
        super.setRequestPayloadTypeClass(HashMap.class);
        super.setRequestMapping(requestMapping);
        if (this.payloadExpression != null) {
            this.evaluationContext = this.createEvaluationContext();
        }
    }

    public String getComponentType() {
        return "aws:sns-inbound-channel-adapter";
    }

    protected void send(Object object) {
        Message message = (Message)object;
        HashMap payload = (HashMap)message.getPayload();
        AbstractIntegrationMessageBuilder messageToSendBuilder = this.payloadExpression != null ? this.getMessageBuilderFactory().withPayload(this.payloadExpression.getValue(this.evaluationContext, (Object)message)).copyHeaders((Map)message.getHeaders()) : this.getMessageBuilderFactory().fromMessage(message);
        String type = (String)payload.get("Type");
        if ("SubscriptionConfirmation".equals(type) || "UnsubscribeConfirmation".equals(type)) {
            JsonNode content = this.jackson2HttpMessageConverter.getObjectMapper().valueToTree((Object)payload);
            NotificationStatus notificationStatus = this.notificationStatusResolver.resolveNotificationStatus(content);
            if (this.handleNotificationStatus) {
                messageToSendBuilder.setHeader("Sns_notificationStatus", (Object)notificationStatus);
            } else {
                if ("SubscriptionConfirmation".equals(type)) {
                    notificationStatus.confirmSubscription();
                }
                return;
            }
        }
        messageToSendBuilder.setHeader("Sns_messageType", (Object)type).setHeader("Sns_messageId", payload.get("MessageId"));
        super.send((Object)messageToSendBuilder.build());
    }

    public void setPayloadExpression(Expression payloadExpression) {
        this.payloadExpression = payloadExpression;
    }

    public void setHeaderExpressions(Map<String, Expression> headerExpressions) {
        throw new UnsupportedOperationException();
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        throw new UnsupportedOperationException();
    }

    public void setMergeWithDefaultConverters(boolean mergeWithDefaultConverters) {
        throw new UnsupportedOperationException();
    }

    public void setHeaderMapper(HeaderMapper<HttpHeaders> headerMapper) {
        throw new UnsupportedOperationException();
    }

    public void setRequestMapping(RequestMapping requestMapping) {
        throw new UnsupportedOperationException();
    }

    public void setRequestPayloadTypeClass(Class<?> requestPayloadType) {
        throw new UnsupportedOperationException();
    }

    public void setExtractReplyPayload(boolean extractReplyPayload) {
        throw new UnsupportedOperationException();
    }

    public void setMultipartResolver(MultipartResolver multipartResolver) {
        throw new UnsupportedOperationException();
    }

    public void setStatusCodeExpression(Expression statusCodeExpression) {
        throw new UnsupportedOperationException();
    }

    private static class NotificationStatusResolver
    extends NotificationStatusHandlerMethodArgumentResolver {
        NotificationStatusResolver(SnsClient amazonSns) {
            super(amazonSns);
        }

        NotificationStatus resolveNotificationStatus(JsonNode content) {
            return (NotificationStatus)this.doResolveArgumentFromNotificationMessage(content, null, null);
        }
    }
}

