/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sns.integration;

import io.awspring.cloud.sns.core.CachingTopicArnResolver;
import io.awspring.cloud.sns.core.SnsAsyncTopicArnResolver;
import io.awspring.cloud.sns.core.TopicArnResolver;
import io.awspring.cloud.sns.integration.SnsBodyBuilder;
import io.awspring.cloud.sns.integration.SnsHeaderMapper;
import io.awspring.cloud.sns.integration.SnsRequestFailureException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.integration.MessageTimeoutException;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.AbstractMessageProducingHandler;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;

public class SnsMessageHandler
extends AbstractMessageProducingHandler {
    private final SnsAsyncClient amazonSns;
    private Expression topicArnExpression;
    private TopicArnResolver topicArnResolver;
    private Expression subjectExpression;
    private Expression messageGroupIdExpression;
    private Expression messageDeduplicationIdExpression;
    private Expression bodyExpression;
    protected static final long DEFAULT_SEND_TIMEOUT = 10000L;
    private EvaluationContext evaluationContext;
    private Expression sendTimeoutExpression = new ValueExpression((Object)10000L);
    private HeaderMapper<Map<String, MessageAttributeValue>> headerMapper;
    private boolean headerMapperSet;

    public SnsMessageHandler(SnsAsyncClient amazonSns) {
        Assert.notNull((Object)amazonSns, (String)"amazonSns must not be null.");
        this.amazonSns = amazonSns;
        this.topicArnResolver = new CachingTopicArnResolver(new SnsAsyncTopicArnResolver(this.amazonSns));
    }

    public void setTopicArn(String topicArn) {
        Assert.hasText((String)topicArn, (String)"topicArn must not be empty.");
        this.topicArnExpression = new LiteralExpression(topicArn);
    }

    public void setTopicArnExpression(Expression topicArnExpression) {
        Assert.notNull((Object)topicArnExpression, (String)"topicArnExpression must not be null.");
        this.topicArnExpression = topicArnExpression;
    }

    public void setTopicArnResolver(TopicArnResolver topicArnResolver) {
        Assert.notNull((Object)topicArnResolver, (String)"'topicArnResolver' must not be null.");
        this.topicArnResolver = topicArnResolver;
    }

    public void setSubject(String subject) {
        Assert.hasText((String)subject, (String)"subject must not be empty.");
        this.subjectExpression = new LiteralExpression(subject);
    }

    public void setSubjectExpression(Expression subjectExpression) {
        Assert.notNull((Object)subjectExpression, (String)"subjectExpression must not be null.");
        this.subjectExpression = subjectExpression;
    }

    public void setMessageGroupId(String messageGroupId) {
        Assert.hasText((String)messageGroupId, (String)"messageGroupId must not be empty.");
        this.messageGroupIdExpression = new LiteralExpression(messageGroupId);
    }

    public void setMessageGroupIdExpression(Expression messageGroupIdExpression) {
        Assert.notNull((Object)messageGroupIdExpression, (String)"messageGroupIdExpression must not be null.");
        this.messageGroupIdExpression = messageGroupIdExpression;
    }

    public void setMessageDeduplicationIdExpression(Expression messageDeduplicationIdExpression) {
        Assert.notNull((Object)messageDeduplicationIdExpression, (String)"messageDeduplicationIdExpression must not be null.");
        this.messageDeduplicationIdExpression = messageDeduplicationIdExpression;
    }

    public void setBodyExpression(Expression bodyExpression) {
        Assert.notNull((Object)bodyExpression, (String)"bodyExpression must not be null.");
        this.bodyExpression = bodyExpression;
    }

    public void setSendTimeout(long sendTimeout) {
        this.setSendTimeoutExpression((Expression)new ValueExpression((Object)sendTimeout));
    }

    public void setSendTimeoutExpressionString(String sendTimeoutExpression) {
        this.setSendTimeoutExpression(EXPRESSION_PARSER.parseExpression(sendTimeoutExpression));
    }

    public void setSendTimeoutExpression(Expression sendTimeoutExpression) {
        Assert.notNull((Object)sendTimeoutExpression, (String)"'sendTimeoutExpression' must not be null");
        this.sendTimeoutExpression = sendTimeoutExpression;
    }

    public void setHeaderMapper(HeaderMapper<Map<String, MessageAttributeValue>> headerMapper) {
        this.headerMapper = headerMapper;
        this.headerMapperSet = true;
    }

    public String getComponentType() {
        return "aws:sns-outbound-channel-adapter";
    }

    protected boolean shouldCopyRequestHeaders() {
        return false;
    }

    protected void onInit() {
        TypeLocator typeLocator;
        super.onInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        if (!this.headerMapperSet) {
            this.setHeaderMapper(new SnsHeaderMapper());
        }
        if ((typeLocator = this.evaluationContext.getTypeLocator()) instanceof StandardTypeLocator) {
            StandardTypeLocator standardTypeLocator = (StandardTypeLocator)typeLocator;
            standardTypeLocator.registerImport("io.awspring.cloud.sns.integration");
        }
    }

    protected void handleMessageInternal(Message<?> message) {
        PublishRequest request = this.messageToAwsRequest(message);
        CompletionStage resultFuture = this.amazonSns.publish(request).handle((response, ex) -> this.handleResponse(message, request, (PublishResponse)response, (Throwable)ex));
        if (this.isAsync()) {
            this.sendOutputs(resultFuture, message);
            return;
        }
        Long sendTimeout = (Long)this.sendTimeoutExpression.getValue(this.evaluationContext, message, Long.class);
        try {
            if (sendTimeout == null || sendTimeout < 0L) {
                ((CompletableFuture)resultFuture).get();
            } else {
                ((CompletableFuture)resultFuture).get(sendTimeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (TimeoutException te) {
            throw new MessageTimeoutException(message, "Timeout waiting for response from AmazonKinesis", (Throwable)te);
        }
        catch (InterruptedException ex2) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ex2);
        }
        catch (ExecutionException ex3) {
            throw new IllegalStateException(ex3);
        }
    }

    protected Message<?> handleResponse(Message<?> message, PublishRequest request, PublishResponse response, Throwable cause) {
        if (cause != null) {
            throw new SnsRequestFailureException(message, request, cause);
        }
        return this.getMessageBuilderFactory().fromMessage(message).copyHeadersIfAbsent(this.additionalOnSuccessHeaders(request, response)).build();
    }

    private PublishRequest messageToAwsRequest(Message<?> message) {
        Object payload = message.getPayload();
        if (payload instanceof PublishRequest) {
            PublishRequest publishRequest = (PublishRequest)payload;
            return publishRequest;
        }
        Assert.state((this.topicArnExpression != null ? 1 : 0) != 0, (String)"'topicArn' or 'topicArnExpression' must be specified.");
        PublishRequest.Builder publishRequest = PublishRequest.builder();
        String topic = (String)this.topicArnExpression.getValue(this.evaluationContext, message, String.class);
        String topicArn = this.topicArnResolver.resolveTopicArn(topic).toString();
        publishRequest.topicArn(topicArn);
        if (this.subjectExpression != null) {
            String subject = (String)this.subjectExpression.getValue(this.evaluationContext, message, String.class);
            publishRequest.subject(subject);
        }
        if (topicArn.endsWith(".fifo")) {
            String messageGroupId = null;
            if (this.messageGroupIdExpression != null) {
                messageGroupId = (String)this.messageGroupIdExpression.getValue(this.evaluationContext, message, String.class);
            }
            Assert.notNull(messageGroupId, () -> "The 'messageGroupIdExpression' [" + this.messageGroupIdExpression + "] must not evaluate to null. The failed request message is " + message);
            publishRequest.messageGroupId(messageGroupId);
            String messageDeduplicationId = null;
            if (this.messageDeduplicationIdExpression != null) {
                messageDeduplicationId = (String)this.messageDeduplicationIdExpression.getValue(this.evaluationContext, message, String.class);
            }
            Assert.notNull(messageDeduplicationId, () -> "The 'messageDeduplicationIdExpression' [" + this.messageDeduplicationIdExpression + "] must not evaluate to null. The failed request message is " + message);
            publishRequest.messageDeduplicationId(messageDeduplicationId);
        } else if (this.messageGroupIdExpression != null || this.messageDeduplicationIdExpression != null) {
            this.logger.info((CharSequence)"The 'messageGroupIdExpression' and 'messageDeduplicationIdExpression' properties are ignored for non-FIFO topics.");
        }
        Object snsMessage = message.getPayload();
        if (this.bodyExpression != null) {
            snsMessage = this.bodyExpression.getValue(this.evaluationContext, message);
        }
        if (snsMessage instanceof SnsBodyBuilder) {
            publishRequest.messageStructure("json").message(((SnsBodyBuilder)snsMessage).build());
        } else {
            publishRequest.message((String)this.getConversionService().convert(snsMessage, String.class));
        }
        if (this.headerMapper != null) {
            this.mapHeaders(message, publishRequest, this.headerMapper);
        }
        return (PublishRequest)publishRequest.build();
    }

    private void mapHeaders(Message<?> message, PublishRequest.Builder publishRequest, HeaderMapper<Map<String, MessageAttributeValue>> headerMapper) {
        HashMap messageAttributes = new HashMap();
        headerMapper.fromHeaders(message.getHeaders(), messageAttributes);
        if (!messageAttributes.isEmpty()) {
            publishRequest.messageAttributes(messageAttributes);
        }
    }

    protected Map<String, ?> additionalOnSuccessHeaders(PublishRequest request, PublishResponse response) {
        return Map.of("Sns_topicArn", request.topicArn(), "Sns_messageId", response.messageId());
    }
}

