/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener;

import io.awspring.cloud.sqs.listener.AsyncComponentAdapters;
import io.awspring.cloud.sqs.listener.AsyncMessageListener;
import io.awspring.cloud.sqs.listener.ContainerComponentFactory;
import io.awspring.cloud.sqs.listener.ContainerOptions;
import io.awspring.cloud.sqs.listener.ContainerOptionsBuilder;
import io.awspring.cloud.sqs.listener.MessageListener;
import io.awspring.cloud.sqs.listener.MessageListenerContainer;
import io.awspring.cloud.sqs.listener.acknowledgement.AcknowledgementResultCallback;
import io.awspring.cloud.sqs.listener.acknowledgement.AsyncAcknowledgementResultCallback;
import io.awspring.cloud.sqs.listener.errorhandler.AsyncErrorHandler;
import io.awspring.cloud.sqs.listener.errorhandler.ErrorHandler;
import io.awspring.cloud.sqs.listener.interceptor.AsyncMessageInterceptor;
import io.awspring.cloud.sqs.listener.interceptor.MessageInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractMessageListenerContainer<T, O extends ContainerOptions<O, B>, B extends ContainerOptionsBuilder<B, O>>
implements MessageListenerContainer<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMessageListenerContainer.class);
    private final Object lifecycleMonitor = new Object();
    private boolean isRunning;
    @Nullable
    private String id;
    private Collection<String> queueNames = new ArrayList<String>();
    private Collection<ContainerComponentFactory<T, O>> containerComponentFactories = new ArrayList<ContainerComponentFactory<T, O>>();
    private AsyncMessageListener<T> messageListener;
    private AsyncErrorHandler<T> errorHandler;
    private final Collection<AsyncMessageInterceptor<T>> messageInterceptors = new ArrayList<AsyncMessageInterceptor<T>>();
    private O containerOptions;
    private AsyncAcknowledgementResultCallback<T> acknowledgementResultCallback = new AsyncAcknowledgementResultCallback<T>(){};

    protected AbstractMessageListenerContainer(O containerOptions) {
        Assert.notNull(containerOptions, (String)"containerOptions cannot be null");
        this.containerOptions = containerOptions;
    }

    @Override
    public void setId(String id) {
        Assert.notNull((Object)id, (String)"id cannot be null");
        this.id = id;
    }

    public void setErrorHandler(ErrorHandler<T> errorHandler) {
        Assert.notNull(errorHandler, (String)"errorHandler cannot be null");
        this.errorHandler = AsyncComponentAdapters.adapt(errorHandler);
    }

    public void setErrorHandler(AsyncErrorHandler<T> errorHandler) {
        Assert.notNull(errorHandler, (String)"errorHandler cannot be null");
        this.errorHandler = errorHandler;
    }

    public void addMessageInterceptor(MessageInterceptor<T> messageInterceptor) {
        Assert.notNull(messageInterceptor, (String)"messageInterceptor cannot be null");
        this.messageInterceptors.add(AsyncComponentAdapters.adapt(messageInterceptor));
    }

    public void addMessageInterceptor(AsyncMessageInterceptor<T> messageInterceptor) {
        Assert.notNull(messageInterceptor, (String)"messageInterceptor cannot be null");
        this.messageInterceptors.add(messageInterceptor);
    }

    @Override
    public void setMessageListener(MessageListener<T> messageListener) {
        Assert.notNull(messageListener, (String)"messageListener cannot be null");
        this.messageListener = AsyncComponentAdapters.adapt(messageListener);
    }

    @Override
    public void setAsyncMessageListener(AsyncMessageListener<T> asyncMessageListener) {
        Assert.notNull(asyncMessageListener, (String)"asyncMessageListener cannot be null");
        this.messageListener = asyncMessageListener;
    }

    public void setAcknowledgementResultCallback(AsyncAcknowledgementResultCallback<T> acknowledgementResultCallback) {
        Assert.notNull(acknowledgementResultCallback, (String)"acknowledgementResultCallback cannot be null");
        this.acknowledgementResultCallback = acknowledgementResultCallback;
    }

    public void setAcknowledgementResultCallback(AcknowledgementResultCallback<T> acknowledgementResultCallback) {
        Assert.notNull(acknowledgementResultCallback, (String)"acknowledgementResultCallback cannot be null");
        this.acknowledgementResultCallback = AsyncComponentAdapters.adapt(acknowledgementResultCallback);
    }

    public void setComponentFactories(Collection<ContainerComponentFactory<T, O>> containerComponentFactories) {
        Assert.notEmpty(containerComponentFactories, (String)"containerComponentFactories cannot be null or empty");
        this.containerComponentFactories = containerComponentFactories;
    }

    public void configure(Consumer<B> options) {
        Assert.state((!this.isRunning() ? 1 : 0) != 0, (String)"Stop the container before making changes to the options");
        Object builder = this.containerOptions.toBuilder();
        options.accept(builder);
        this.containerOptions = builder.build();
    }

    public O getContainerOptions() {
        return this.containerOptions;
    }

    public Collection<ContainerComponentFactory<T, O>> getContainerComponentFactories() {
        return Collections.unmodifiableCollection(this.containerComponentFactories);
    }

    public AsyncMessageListener<T> getMessageListener() {
        return this.messageListener;
    }

    public AsyncErrorHandler<T> getErrorHandler() {
        return this.errorHandler;
    }

    public Collection<AsyncMessageInterceptor<T>> getMessageInterceptors() {
        return Collections.unmodifiableCollection(this.messageInterceptors);
    }

    public AsyncAcknowledgementResultCallback<T> getAcknowledgementResultCallback() {
        return this.acknowledgementResultCallback;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setQueueNames(Collection<String> queueNames) {
        Assert.notEmpty(queueNames, (String)"queueNames cannot be empty");
        this.queueNames = queueNames;
    }

    public void setQueueNames(String ... queueNames) {
        this.setQueueNames(Arrays.asList(queueNames));
    }

    public Collection<String> getQueueNames() {
        return Collections.unmodifiableCollection(this.queueNames);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.isRunning) {
            return;
        }
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            Assert.state((!this.queueNames.isEmpty() ? 1 : 0) != 0, (String)"Queue names not set");
            Assert.notNull(this.messageListener, (String)"messageListener cannot be null");
            this.isRunning = true;
            if (this.id == null) {
                this.id = this.resolveContainerId();
            }
            logger.debug("Starting container {}", (Object)this.getId());
            this.doStart();
        }
        logger.info("Container {} started", (Object)this.id);
    }

    private String resolveContainerId() {
        String firstQueueName = this.queueNames.iterator().next();
        return firstQueueName.startsWith("http") ? firstQueueName.substring(Math.max(firstQueueName.length() - 10, 0)) + "-container" : firstQueueName.substring(0, Math.min(15, firstQueueName.length())) + "-container";
    }

    protected void doStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.isRunning) {
            return;
        }
        logger.debug("Stopping container {}", (Object)this.id);
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.isRunning = false;
            this.doStop();
        }
        logger.info("Container {} stopped", (Object)this.id);
    }

    protected void doStop() {
    }
}

