/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.pipeline;

import io.awspring.cloud.sqs.CompletableFutures;
import io.awspring.cloud.sqs.listener.ListenerExecutionFailedException;
import io.awspring.cloud.sqs.listener.MessageProcessingContext;
import io.awspring.cloud.sqs.listener.acknowledgement.handler.AcknowledgementHandler;
import io.awspring.cloud.sqs.listener.pipeline.MessageProcessingConfiguration;
import io.awspring.cloud.sqs.listener.pipeline.MessageProcessingPipeline;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;

public class AcknowledgementHandlerExecutionStage<T>
implements MessageProcessingPipeline<T> {
    private static final Logger logger = LoggerFactory.getLogger(AcknowledgementHandlerExecutionStage.class);
    private final AcknowledgementHandler<T> acknowledgementHandler;

    public AcknowledgementHandlerExecutionStage(MessageProcessingConfiguration<T> configuration) {
        this.acknowledgementHandler = configuration.getAckHandler();
    }

    @Override
    public CompletableFuture<Message<T>> process(CompletableFuture<Message<T>> messageFuture, MessageProcessingContext<T> context) {
        return CompletableFutures.handleCompose(messageFuture, (v, t) -> t == null ? this.acknowledgementHandler.onSuccess(v, context.getAcknowledgmentCallback()).thenApply(theVoid -> v) : this.acknowledgementHandler.onError(ListenerExecutionFailedException.unwrapMessage(t), (Throwable)t, context.getAcknowledgmentCallback()).thenCompose(theVoid -> CompletableFutures.failedFuture(t)));
    }

    @Override
    public CompletableFuture<Collection<Message<T>>> processMany(CompletableFuture<Collection<Message<T>>> messagesFuture, MessageProcessingContext<T> context) {
        return CompletableFutures.handleCompose(messagesFuture, (v, t) -> {
            Collection originalMessages = ListenerExecutionFailedException.unwrapMessages(t);
            return t == null ? this.acknowledgementHandler.onSuccess(v, context.getAcknowledgmentCallback()).thenApply(theVoid -> v) : this.acknowledgementHandler.onError(originalMessages, (Throwable)t, context.getAcknowledgmentCallback()).thenCompose(theVoid -> CompletableFutures.failedFuture(t));
        });
    }
}

