/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.acknowledgement;

import io.awspring.cloud.sqs.MessageHeaderUtils;
import io.awspring.cloud.sqs.listener.acknowledgement.AcknowledgementCallback;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.springframework.messaging.Message;

public interface Acknowledgement {
    public void acknowledge();

    public CompletableFuture<Void> acknowledgeAsync();

    public static void acknowledge(Message<?> message) {
        Acknowledgement.acknowledgeAsync(message).join();
    }

    public static CompletableFuture<Void> acknowledgeAsync(Message<?> message) {
        return MessageHeaderUtils.getHeader(message, "AcknowledgementCallback", AcknowledgementCallback.class).onAcknowledge(message);
    }

    public static <T> void acknowledge(Collection<Message<T>> messages) {
        Acknowledgement.acknowledgeAsync(messages).join();
    }

    public static <T> CompletableFuture<Void> acknowledgeAsync(Collection<Message<T>> messages) {
        return !messages.isEmpty() ? MessageHeaderUtils.getHeader(messages.iterator().next(), "AcknowledgementCallback", AcknowledgementCallback.class).onAcknowledge(messages) : CompletableFuture.completedFuture(null);
    }
}

