/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener;

import io.awspring.cloud.sqs.listener.BackPressureMode;
import io.awspring.cloud.sqs.listener.ConfigurableContainerComponent;
import io.awspring.cloud.sqs.listener.ContainerOptionsBuilder;
import io.awspring.cloud.sqs.listener.ListenerMode;
import io.awspring.cloud.sqs.listener.acknowledgement.AcknowledgementOrdering;
import io.awspring.cloud.sqs.listener.acknowledgement.handler.AcknowledgementMode;
import io.awspring.cloud.sqs.support.converter.MessagingMessageConverter;
import java.time.Duration;
import java.util.Collection;
import org.springframework.core.task.TaskExecutor;
import org.springframework.lang.Nullable;
import org.springframework.retry.backoff.BackOffPolicy;

public interface ContainerOptions<O extends ContainerOptions<O, B>, B extends ContainerOptionsBuilder<B, O>> {
    public int getMaxConcurrentMessages();

    public int getMaxMessagesPerPoll();

    public boolean isAutoStartup();

    public Duration getMaxDelayBetweenPolls();

    public Duration getPollTimeout();

    default public BackOffPolicy getPollBackOffPolicy() {
        throw new UnsupportedOperationException("Poll Back Off not supported by this ContainerOptions");
    }

    @Nullable
    public TaskExecutor getComponentsTaskExecutor();

    @Nullable
    public TaskExecutor getAcknowledgementResultTaskExecutor();

    public Duration getListenerShutdownTimeout();

    public Duration getAcknowledgementShutdownTimeout();

    public BackPressureMode getBackPressureMode();

    public ListenerMode getListenerMode();

    public MessagingMessageConverter<?> getMessageConverter();

    @Nullable
    public Duration getAcknowledgementInterval();

    @Nullable
    public Integer getAcknowledgementThreshold();

    public AcknowledgementMode getAcknowledgementMode();

    @Nullable
    public AcknowledgementOrdering getAcknowledgementOrdering();

    default public O configure(ConfigurableContainerComponent configurable) {
        configurable.configure(this);
        return (O)this;
    }

    default public O configure(Collection<? extends ConfigurableContainerComponent> configurables) {
        configurables.forEach(this::configure);
        return (O)this;
    }

    default public O createCopy() {
        return this.toBuilder().build();
    }

    public B toBuilder();
}

