/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.errorhandler;

import io.awspring.cloud.sqs.MessageHeaderUtils;
import io.awspring.cloud.sqs.listener.BatchVisibility;
import io.awspring.cloud.sqs.listener.QueueMessageVisibility;
import io.awspring.cloud.sqs.listener.Visibility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class ErrorHandlerVisibilityHelper {
    public static <T> Map<Long, List<Message<T>>> groupMessagesByReceiveMessageCount(Collection<Message<T>> messages) {
        return messages.stream().collect(Collectors.groupingBy(ErrorHandlerVisibilityHelper::getReceiveMessageCount));
    }

    public static <T> Collection<Message<?>> castMessages(Collection<Message<T>> messages) {
        return new ArrayList(messages);
    }

    public static <T> Visibility getVisibility(Message<T> message) {
        return MessageHeaderUtils.getHeader(message, "Sqs_VisibilityTimeout", Visibility.class);
    }

    public static <T> BatchVisibility getVisibility(Collection<Message<T>> messages) {
        Collection<Message<?>> castMessages = ErrorHandlerVisibilityHelper.castMessages(messages);
        QueueMessageVisibility firstVisibilityMessage = (QueueMessageVisibility)ErrorHandlerVisibilityHelper.getVisibility(messages.iterator().next());
        return firstVisibilityMessage.toBatchVisibility(castMessages);
    }

    public static <T> long getReceiveMessageCount(Message<T> message) {
        return Long.parseLong(MessageHeaderUtils.getHeaderAsString(message, "Sqs_Msa_ApproximateReceiveCount"));
    }

    public static int calculateVisibilityTimeoutExponentially(long receiveMessageCount, int initialVisibilityTimeoutSeconds, double multiplier, int maxVisibilityTimeoutSeconds) {
        double timeout = (double)initialVisibilityTimeoutSeconds * Math.pow(multiplier, receiveMessageCount - 1L);
        int capped = (int)Math.min(timeout, 2.147483647E9);
        return Math.min(capped, maxVisibilityTimeoutSeconds);
    }

    public static int calculateVisibilityTimeoutLinearly(long receiveMessageCount, int initialVisibilityTimeoutSeconds, int increment, int maxVisibilityTimeoutSeconds) {
        long timeout = (long)initialVisibilityTimeoutSeconds + (long)increment * (receiveMessageCount - 1L);
        int capped = (int)Math.min(timeout, Integer.MAX_VALUE);
        return Math.min(capped, maxVisibilityTimeoutSeconds);
    }

    public static void checkVisibilityTimeout(long visibilityTimeout) {
        Assert.isTrue((visibilityTimeout > 0L ? 1 : 0) != 0, () -> "Invalid visibility timeout '" + visibilityTimeout + "'. Should be greater than 0 ");
        Assert.isTrue((visibilityTimeout <= 43200L ? 1 : 0) != 0, () -> "Invalid visibility timeout '" + visibilityTimeout + "'. Should be less than or equal to 43200");
    }
}

