/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.errorhandler;

import io.awspring.cloud.sqs.listener.BatchVisibility;
import io.awspring.cloud.sqs.listener.Visibility;
import io.awspring.cloud.sqs.listener.errorhandler.AsyncErrorHandler;
import io.awspring.cloud.sqs.listener.errorhandler.ErrorHandlerVisibilityHelper;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.springframework.messaging.Message;

public class ImmediateRetryAsyncErrorHandler<T>
implements AsyncErrorHandler<T> {
    @Override
    public CompletableFuture<Void> handle(Message<T> message, Throwable t) {
        return this.changeTimeoutToZero(message).thenCompose(theVoid -> CompletableFuture.failedFuture(t));
    }

    @Override
    public CompletableFuture<Void> handle(Collection<Message<T>> messages, Throwable t) {
        return this.changeTimeoutToZero(messages).thenCompose(theVoid -> CompletableFuture.failedFuture(t));
    }

    private CompletableFuture<Void> changeTimeoutToZero(Message<T> message) {
        Visibility visibilityTimeout = ErrorHandlerVisibilityHelper.getVisibility(message);
        return visibilityTimeout.changeToAsync(0);
    }

    private CompletableFuture<Void> changeTimeoutToZero(Collection<Message<T>> messages) {
        BatchVisibility visibility = ErrorHandlerVisibilityHelper.getVisibility(messages);
        return visibility.changeToAsync(0);
    }
}

