/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.awspring.cloud.sqs.support.converter.SnsNotification;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.util.Assert;

public class SnsNotificationConverter
implements SmartMessageConverter {
    private final ObjectMapper jsonMapper;
    private final MessageConverter payloadConverter;

    public SnsNotificationConverter(MessageConverter payloadConverter, ObjectMapper jsonMapper) {
        Assert.notNull((Object)payloadConverter, (String)"payloadConverter must not be null");
        Assert.notNull((Object)jsonMapper, (String)"jsonMapper must not be null");
        this.payloadConverter = payloadConverter;
        this.jsonMapper = jsonMapper;
    }

    public Object fromMessage(Message<?> message, Class<?> targetClass, @Nullable Object conversionHint) {
        Assert.notNull(message, (String)"message must not be null");
        Assert.notNull(targetClass, (String)"target class must not be null");
        Object payload = message.getPayload();
        if (payload instanceof List) {
            List messages = (List)payload;
            return this.fromGenericMessages(messages, targetClass, conversionHint);
        }
        return this.fromGenericMessage((GenericMessage)message, targetClass, conversionHint);
    }

    private Object fromGenericMessages(List<GenericMessage<?>> messages, Class<?> targetClass, @Nullable Object conversionHint) {
        Object object;
        Type resolvedType = SnsNotificationConverter.getResolvedType(targetClass, conversionHint);
        Class resolvedClazz = ResolvableType.forType((Type)resolvedType).resolve();
        if (targetClass.isAssignableFrom(List.class) && conversionHint instanceof MethodParameter) {
            MethodParameter mp = (MethodParameter)conversionHint;
            object = mp.nested();
        } else {
            object = conversionHint;
        }
        Object hint = object;
        return messages.stream().map(message -> this.fromGenericMessage((GenericMessage<?>)message, resolvedClazz, hint)).toList();
    }

    private Object fromGenericMessage(GenericMessage<?> message, Class<?> targetClass, @Nullable Object conversionHint) {
        try {
            Type payloadType = this.getPayloadType(targetClass, conversionHint);
            Class payloadClass = ResolvableType.forType((Type)payloadType).resolve();
            return this.jsonMapper.readValue(message.getPayload().toString(), this.jsonMapper.getTypeFactory().constructParametricType(SnsNotification.class, new Class[]{payloadClass}));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error converting SNS notification: " + e.getMessage(), e);
        }
    }

    private Type getPayloadType(Class<?> targetClass, @Nullable Object conversionHint) {
        MethodParameter parameter;
        ResolvableType resolvableType;
        if (conversionHint instanceof MethodParameter && (resolvableType = ResolvableType.forMethodParameter((MethodParameter)(parameter = (MethodParameter)conversionHint))).isAssignableFrom(SnsNotification.class)) {
            return resolvableType.getGeneric(new int[]{0}).getType();
        }
        return String.class;
    }

    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        return this.fromMessage(message, targetClass, null);
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers) {
        throw new UnsupportedOperationException("This converter only supports reading SNS notifications and not writing them");
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers, Object conversionHint) {
        throw new UnsupportedOperationException("This converter only supports reading SNS notifications and not writing them");
    }

    private static Type getResolvedType(Class<?> targetClass, @Nullable Object conversionHint) {
        if (conversionHint instanceof MethodParameter) {
            Class contextClass;
            Type genericParameterType;
            Type resolveType;
            MethodParameter param = (MethodParameter)conversionHint;
            if (Message.class.isAssignableFrom((param = param.nestedIfOptional()).getParameterType())) {
                param = param.nested();
            }
            if ((resolveType = GenericTypeResolver.resolveType((Type)(genericParameterType = param.getNestedGenericParameterType()), (Class)(contextClass = param.getContainingClass()))) instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)resolveType;
                return parameterizedType.getActualTypeArguments()[0];
            }
            return resolveType;
        }
        return targetClass;
    }
}

