/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.resolver;

import io.awspring.cloud.sqs.MessageHeaderUtils;
import io.awspring.cloud.sqs.listener.BatchVisibility;
import io.awspring.cloud.sqs.listener.QueueMessageVisibility;
import java.util.Collection;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class BatchVisibilityHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final String visibilityHeaderName;

    public BatchVisibilityHandlerMethodArgumentResolver(String visibilityHeaderName) {
        this.visibilityHeaderName = visibilityHeaderName;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return ClassUtils.isAssignable(BatchVisibility.class, (Class)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, Message<?> message) {
        Object payloadObject = message.getPayload();
        Assert.isInstanceOf(Collection.class, (Object)payloadObject, (String)"Payload must be instance of Collection");
        Collection messages = (Collection)payloadObject;
        QueueMessageVisibility visibilityObject = MessageHeaderUtils.getHeader((Message)messages.iterator().next(), this.visibilityHeaderName, QueueMessageVisibility.class);
        return visibilityObject.toBatchVisibility(messages);
    }
}

